/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.common.tool;

import com.valor.vod.hotkey.common.annotation.SPI;
import com.valor.vod.hotkey.common.tool.ClassUtils;
import com.valor.vod.hotkey.common.tool.DefaultObjectFactory;
import com.valor.vod.hotkey.common.tool.ObjectFactory;
import com.valor.vod.hotkey.common.tool.ServiceConfigurationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader<T> {
    public static final String SERVICES_FOLDER = "META-INF/services/";
    public static final String HK_FOLDER = "META-INF/services/hk";
    private static final Logger logger = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final ObjectFactory objectFactory = new DefaultObjectFactory();
    private static final Map<Class<?>, ExtensionLoader<?>> EXTENSION_LOADER_MAP = new ConcurrentHashMap();
    private final Class<?> baseClass;
    private volatile Map<String, Class<?>> cachedClasses;
    private volatile Map<String, Object> cachedActives;

    public ExtensionLoader(Class<?> baseClass) {
        this.baseClass = baseClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(String name) {
        Object obj;
        if (this.cachedActives == null) {
            ExtensionLoader extensionLoader = this;
            synchronized (extensionLoader) {
                if (this.cachedActives == null) {
                    this.cachedActives = new ConcurrentSkipListMap<String, Object>();
                }
            }
        }
        if ((obj = this.cachedActives.get(name)) == null) {
            ExtensionLoader extensionLoader = this;
            synchronized (extensionLoader) {
                obj = this.cachedActives.get(name);
                if (obj == null) {
                    Class<?> clazz;
                    if (this.cachedClasses == null) {
                        this.cachedClasses = this.loadServiceClasses();
                    }
                    if ((clazz = this.cachedClasses.get(name)) == null) {
                        throw new ServiceConfigurationException("No such service named:" + name + ", baseClass:" + this.baseClass.getName());
                    }
                    try {
                        obj = objectFactory.buildObject(clazz);
                        this.cachedActives.put(name, obj);
                    }
                    catch (Exception e) {
                        throw new ServiceConfigurationException("Can't initialize service class : " + clazz.getName());
                    }
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadClasses() {
        if (this.cachedClasses == null) {
            ExtensionLoader extensionLoader = this;
            synchronized (extensionLoader) {
                if (this.cachedClasses == null) {
                    this.cachedClasses = this.loadServiceClasses();
                }
            }
        }
    }

    private Map<String, Class<?>> loadServiceClasses() {
        HashMap serviceClasses = new HashMap();
        ExtensionLoader.load(this, serviceClasses, SERVICES_FOLDER);
        ExtensionLoader.load(this, serviceClasses, HK_FOLDER);
        return serviceClasses;
    }

    public Object getAdaptiveService() {
        SPI spi = this.baseClass.getAnnotation(SPI.class);
        if (spi.value().length() > 0) {
            return this.getService(spi.value());
        }
        Object obj = null;
        for (String name : this.cachedClasses.keySet()) {
            try {
                obj = this.getService(name);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
            }
        }
        if (obj == null) {
            throw new ServiceConfigurationException(this.baseClass.getName() + " have no implements");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void load(ExtensionLoader<T> loader, Map<String, Class<?>> serviceClasses, String pos) {
        block17: {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Load service " + pos + loader.baseClass.getName());
                }
                ClassLoader classLoader = ExtensionLoader.findClassLoader();
                Enumeration<URL> urls = null;
                String fileName = pos + loader.baseClass.getName();
                urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
                if (urls == null) break block17;
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                    try {
                        String line = br.readLine();
                        while (line != null) {
                            if (!(line = line.trim()).startsWith("#")) {
                                String value;
                                String name;
                                if (line.contains("=")) {
                                    String[] nameValue = line.split("=");
                                    name = nameValue[0].trim();
                                    value = nameValue[1].trim();
                                } else {
                                    name = line;
                                    value = line;
                                }
                                try {
                                    Class<?> clazz = ClassUtils.forName(value);
                                    serviceClasses.put(name, clazz);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            line = br.readLine();
                        }
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationException("load error", e);
            }
        }
    }

    private static ClassLoader findClassLoader() {
        return ClassUtils.getClassLoader(ExtensionLoader.class);
    }

    private static <T> T loadService(Class<T> service, String serviceName, ClassLoader cl) {
        Class<?> c;
        try {
            c = Class.forName(serviceName, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceConfigurationException("class not found", e);
        }
        if (!service.isAssignableFrom(c)) {
            throw new ServiceConfigurationException(serviceName + " not a subtype of " + service.getName());
        }
        try {
            return service.cast(c.newInstance());
        }
        catch (Exception e) {
            throw new ServiceConfigurationException(serviceName + " initialize fail");
        }
    }

    public static <T> ExtensionLoader<T> getServiceLoader(Class<T> service) {
        ExtensionLoader.checkClassSpi(service);
        ExtensionLoader<Object> loader = EXTENSION_LOADER_MAP.get(service);
        if (loader == null) {
            loader = new ExtensionLoader<T>(service);
            EXTENSION_LOADER_MAP.putIfAbsent(service, loader);
            loader = EXTENSION_LOADER_MAP.get(service);
        }
        return loader;
    }

    public static <T> T getService(String name, Class<T> service) {
        ExtensionLoader.checkClassSpi(service);
        ExtensionLoader<T> loader = ExtensionLoader.getServiceLoader(service);
        return (T)loader.getService(name);
    }

    public static <T> T getDefaultService(Class<T> service) {
        ExtensionLoader.checkClassSpi(service);
        SPI spi = service.getAnnotation(SPI.class);
        if (spi.value().length() <= 0) {
            throw new ServiceConfigurationException(service.getName() + " has no default service");
        }
        return ExtensionLoader.getService(spi.value(), service);
    }

    private static void checkClassSpi(Class<?> service) {
        if (service == null || !service.isInterface() || service.getAnnotation(SPI.class) == null) {
            throw new ServiceConfigurationException("SPI annotation is missing!");
        }
    }

    public static <T> T getAdaptiveService(Class<T> service) {
        ExtensionLoader.checkClassSpi(service);
        ExtensionLoader<T> loader = ExtensionLoader.getServiceLoader(service);
        return (T)loader.getAdaptiveService();
    }
}

