/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.common.tool;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

@Deprecated
public final class IpUtils {
    public static final String IP_REGEX = "((\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3})";
    private static volatile String cachedIpAddress;

    public static String getIp() {
        Enumeration<NetworkInterface> netInterfaces;
        if (null != cachedIpAddress) {
            return cachedIpAddress;
        }
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return null;
        }
        String localIpAddress = null;
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = netInterfaces.nextElement();
            Enumeration<InetAddress> ipAddresses = netInterface.getInetAddresses();
            while (ipAddresses.hasMoreElements()) {
                InetAddress ipAddress = ipAddresses.nextElement();
                if (IpUtils.isPublicIpAddress(ipAddress)) {
                    String publicIpAddress;
                    cachedIpAddress = publicIpAddress = ipAddress.getHostAddress();
                    return publicIpAddress;
                }
                if (!IpUtils.isLocalIpAddress(ipAddress)) continue;
                localIpAddress = ipAddress.getHostAddress();
            }
        }
        cachedIpAddress = localIpAddress;
        return localIpAddress;
    }

    private static boolean isPublicIpAddress(InetAddress ipAddress) {
        return !ipAddress.isSiteLocalAddress() && !ipAddress.isLoopbackAddress() && !IpUtils.isV6IpAddress(ipAddress);
    }

    private static boolean isLocalIpAddress(InetAddress ipAddress) {
        return ipAddress.isSiteLocalAddress() && !ipAddress.isLoopbackAddress() && !IpUtils.isV6IpAddress(ipAddress);
    }

    private static boolean isV6IpAddress(InetAddress ipAddress) {
        return ipAddress.getHostAddress().contains(":");
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }
}

