/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.common.tool.flush;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushUtil {
    private static Logger logger = LoggerFactory.getLogger("flushUtil");

    public static void flush(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (channelHandlerContext.channel().isWritable()) {
            channelHandlerContext.channel().writeAndFlush(byteBuf).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (!future.isSuccess()) {
                    logger.warn("flush error " + future.cause().getMessage());
                }
            }));
        } else {
            try {
                channelHandlerContext.channel().writeAndFlush(byteBuf).sync();
            }
            catch (InterruptedException e) {
                logger.error("flush error " + e.getMessage());
            }
        }
    }
}

