/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.configcenter.etcd;

import com.google.protobuf.ByteString;
import com.ibm.etcd.api.Event;
import com.ibm.etcd.api.KeyValue;
import com.ibm.etcd.api.LeaseGrantResponse;
import com.ibm.etcd.api.LeaseTimeToLiveResponse;
import com.ibm.etcd.api.RangeResponse;
import com.ibm.etcd.client.KvStoreClient;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.kv.WatchUpdate;
import com.ibm.etcd.client.lease.LeaseClient;
import com.ibm.etcd.client.lease.PersistentLease;
import com.ibm.etcd.client.lock.LockClient;
import com.valor.vod.hotkey.common.configcenter.AbstractConfigCenter;
import com.valor.vod.hotkey.common.configcenter.model.DataEvent;
import com.valor.vod.hotkey.common.configcenter.model.EventType;
import com.valor.vod.hotkey.common.configcenter.model.KvData;
import com.valor.vod.hotkey.common.tool.CollectionUtil;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdConfigCenter
extends AbstractConfigCenter
implements StreamObserver<WatchUpdate> {
    private static final Logger logger = LoggerFactory.getLogger(EtcdConfigCenter.class);
    private KvClient kvClient;
    private LeaseClient leaseClient;
    private LockClient lockClient;
    private final Map<AbstractConfigCenter.SubscribeKey, KvClient.Watch> watchMap = new ConcurrentHashMap<AbstractConfigCenter.SubscribeKey, KvClient.Watch>();
    private static final Map<Event.EventType, EventType> EVENT_TYPE_MAP = new HashMap<Event.EventType, EventType>();

    public EtcdConfigCenter(KvStoreClient kvStoreClient) {
        this.kvClient = kvStoreClient.getKvClient();
        this.leaseClient = kvStoreClient.getLeaseClient();
        this.lockClient = kvStoreClient.getLockClient();
    }

    public LeaseClient getLeaseClient() {
        return this.leaseClient;
    }

    public void setLeaseClient(LeaseClient leaseClient) {
        this.leaseClient = leaseClient;
    }

    public KvClient getKvClient() {
        return this.kvClient;
    }

    public void setKvClient(KvClient kvClient) {
        this.kvClient = kvClient;
    }

    public LockClient getLockClient() {
        return this.lockClient;
    }

    public void setLockClient(LockClient lockClient) {
        this.lockClient = lockClient;
    }

    @Override
    public void put(String key, String value) {
        this.kvClient.put(ByteString.copyFromUtf8(key), ByteString.copyFromUtf8(value)).sync();
    }

    @Override
    public void add(String key, String value) {
        this.kvClient.put(ByteString.copyFromUtf8(key), ByteString.copyFromUtf8(value)).sync();
    }

    @Override
    public void put(String key, String value, long leaseId) {
        this.kvClient.put(ByteString.copyFromUtf8(key), ByteString.copyFromUtf8(value), leaseId).sync();
    }

    @Override
    public void revoke(long leaseId) {
        this.leaseClient.revoke(leaseId);
    }

    @Override
    public long putAndGrant(String key, String value, long ttl) {
        LeaseGrantResponse lease = (LeaseGrantResponse)this.leaseClient.grant(ttl).sync();
        this.put(key, value, lease.getID());
        return lease.getID();
    }

    @Override
    public long setLease(String key, long leaseId) {
        this.kvClient.setLease(ByteString.copyFromUtf8(key), leaseId);
        return leaseId;
    }

    @Override
    public void delete(String key) {
        this.kvClient.delete(ByteString.copyFromUtf8(key)).sync();
    }

    @Override
    public String get(String key) {
        RangeResponse rangeResponse = (RangeResponse)this.kvClient.get(ByteString.copyFromUtf8(key)).sync();
        List<KeyValue> keyValues = rangeResponse.getKvsList();
        if (CollectionUtil.isEmpty(keyValues)) {
            return null;
        }
        return keyValues.get(0).getValue().toStringUtf8();
    }

    @Override
    public KvData getKvData(String key) {
        RangeResponse rangeResponse = (RangeResponse)this.kvClient.get(ByteString.copyFromUtf8(key)).sync();
        List<KeyValue> keyValues = rangeResponse.getKvsList();
        if (CollectionUtil.isEmpty(keyValues)) {
            return null;
        }
        return this.convert(keyValues.get(0));
    }

    @Override
    public List<KvData> getKvDataPrefix(String key) {
        RangeResponse rangeResponse = (RangeResponse)this.kvClient.get(ByteString.copyFromUtf8(key)).asPrefix().sync();
        return rangeResponse.getKvsList().stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public long keepAlive(String key, String value, int frequencySecs, int minTtl) throws Exception {
        PersistentLease lease = this.leaseClient.maintain().leaseId(System.currentTimeMillis()).keepAliveFreq(frequencySecs).minTtl(minTtl).start();
        long newId = (Long)lease.get(3L, TimeUnit.SECONDS);
        this.put(key, value, newId);
        return newId;
    }

    @Override
    public long buildAliveLease(int frequencySecs, int minTtl) throws Exception {
        PersistentLease lease = this.leaseClient.maintain().leaseId(System.currentTimeMillis()).keepAliveFreq(frequencySecs).minTtl(minTtl).start();
        return (Long)lease.get(3L, TimeUnit.SECONDS);
    }

    @Override
    public long buildNormalLease(long ttl) {
        LeaseGrantResponse lease = (LeaseGrantResponse)this.leaseClient.grant(ttl).sync();
        return lease.getID();
    }

    @Override
    public long timeToLive(long leaseId) {
        try {
            return ((LeaseTimeToLiveResponse)this.leaseClient.ttl(leaseId).get()).getTTL();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    protected void doSubscribe(AbstractConfigCenter.SubscribeKey sk) {
        this.watchMap.computeIfAbsent(sk, key -> {
            KvClient.FluentWatchRequest watchRequest = this.kvClient.watch(ByteString.copyFromUtf8(sk.getKey()));
            if (sk.isPrefix()) {
                watchRequest.asPrefix();
            }
            return watchRequest.start(this);
        });
    }

    @Override
    protected void doUnsubscribe(AbstractConfigCenter.SubscribeKey sk) {
        KvClient.Watch watch = this.watchMap.remove(sk);
        if (watch != null) {
            watch.close();
        }
    }

    @Override
    public void onNext(WatchUpdate watchUpdate) {
        List<Event> events = watchUpdate.getEvents();
        if (events != null && !events.isEmpty()) {
            for (Event event : events) {
                KvData kvData = this.convert(event.getKv());
                this.fireDataChange(new DataEvent(kvData.getKey(), kvData, EVENT_TYPE_MAP.get(event.getType())));
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        logger.error("Watch error.", throwable);
    }

    @Override
    public void onCompleted() {
    }

    private KvData convert(KeyValue keyValue) {
        KvData kvData = new KvData();
        kvData.setKey(keyValue.getKey().toStringUtf8());
        kvData.setValue(keyValue.getValue().toStringUtf8());
        kvData.getProperties().put("lease", keyValue.getLease());
        kvData.getProperties().put("modRevision", keyValue.getModRevision());
        return kvData;
    }

    static {
        EVENT_TYPE_MAP.put(Event.EventType.PUT, EventType.PUT);
        EVENT_TYPE_MAP.put(Event.EventType.DELETE, EventType.DELETE);
        EVENT_TYPE_MAP.put(Event.EventType.UNRECOGNIZED, EventType.UNRECOGNIZED);
    }
}

