package com.valor.vod.hotkey.client.configcenter;

import com.valor.vod.hotkey.client.log.JdLogger;
import com.valor.vod.hotkey.common.configcenter.*;
import com.valor.vod.hotkey.common.tool.ExtensionLoader;

/**
 * @author wuweifeng wrote on 2020-01-07
 * @version 1.0
 */
public class ConfigCenterFactory {

    private static IConfigCenter configCenter;

    private ConfigCenterFactory() {}

    public static IConfigCenter configCenter() {
        return configCenter;
    }

    /**
     * 构建配置中心
     *
     * @param etcdServer
     */
    public static void buildConfigCenter(String etcdServer) {
        // 连接多个时，逗号分隔
        ConfigCenterCfg cfg = ConfigCenterCfg.builder().type("etcd").adders(etcdServer).build();
        buildConfigCenter(cfg);
    }

    /**
     * 构建配置中心
     *
     * @param cfg
     */
    public static void buildConfigCenter(ConfigCenterCfg cfg) {
        JdLogger.info(ConfigCenterFactory.class, "ConfigCenter config:" + cfg);
        IConfigCenterFactory configCenterFactory =
                ExtensionLoader.getService(cfg.getType(), IConfigCenterFactory.class);
        configCenter = configCenterFactory.build(cfg);
    }
}
