package com.valor.vod.hotkey.client.core.key;

import com.valor.vod.hotkey.client.Context;
import com.valor.vod.hotkey.common.model.HotKeyModel;
import com.valor.vod.hotkey.common.model.KeyCountModel;
import com.valor.vod.hotkey.common.tool.CollectionUtil;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * 定时推送一批key到worker
 *
 * @author wuweifeng wrote on 2020-01-06
 * @version 1.0
 */
public class PushSchedulerStarter {

    private ScheduledExecutorService scheduledExecutor;

    public PushSchedulerStarter(ScheduledExecutorService scheduled) {
        this.scheduledExecutor = scheduled;
    }

    /**
     * 每隔一段时间(默认500ms)推送一次待测key
     *
     * @param period 间隔(ms)
     */
    public void startPusher(Long period) {
        if (period == null || period <= 0) {
            period = 500L;
        }
        scheduledExecutor.scheduleAtFixedRate(
                () -> {
                    IKeyCollector<HotKeyModel, HotKeyModel> collectHK =
                            KeyHandlerFactory.getCollector();
                    List<HotKeyModel> hotKeyModels = collectHK.lockAndGetResult();
                    if (CollectionUtil.isNotEmpty(hotKeyModels)) {
                        KeyHandlerFactory.getPusher().send(Context.APP_NAME, hotKeyModels);
                        collectHK.finishOnce();
                    }
                },
                0,
                period,
                TimeUnit.MILLISECONDS);
    }

    /**
     * 每隔一段时间(默认10s)推送一次数量统计
     *
     * @param period 间隔(s)
     */
    public void startCountPusher(Integer period) {
        if (period == null || period <= 0) {
            period = 10;
        }
        scheduledExecutor.scheduleAtFixedRate(
                () -> {
                    IKeyCollector<KeyHotModel, KeyCountModel> collectHK =
                            KeyHandlerFactory.getCounter();
                    List<KeyCountModel> keyCountModels = collectHK.lockAndGetResult();
                    if (CollectionUtil.isNotEmpty(keyCountModels)) {
                        KeyHandlerFactory.getPusher().sendCount(Context.APP_NAME, keyCountModels);
                        collectHK.finishOnce();
                    }
                },
                0,
                period,
                TimeUnit.SECONDS);
    }
}
