/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.configcenter;

import com.valor.vod.hotkey.client.Context;
import com.valor.vod.hotkey.client.callback.ReceiveNewKeyEvent;
import com.valor.vod.hotkey.client.configcenter.ConfigCenterFactory;
import com.valor.vod.hotkey.client.core.eventbus.EventBusCenter;
import com.valor.vod.hotkey.client.core.rule.KeyRuleInfoChangeEvent;
import com.valor.vod.hotkey.client.core.worker.WorkerInfoChangeEvent;
import com.valor.vod.hotkey.client.core.worker.WorkerInfoHolder;
import com.valor.vod.hotkey.client.log.JdLogger;
import com.valor.vod.hotkey.common.configcenter.IConfigCenter;
import com.valor.vod.hotkey.common.configcenter.INotifyListener;
import com.valor.vod.hotkey.common.configcenter.model.DataEvent;
import com.valor.vod.hotkey.common.configcenter.model.EventType;
import com.valor.vod.hotkey.common.configcenter.model.KvData;
import com.valor.vod.hotkey.common.model.HotKeyModel;
import com.valor.vod.hotkey.common.rule.KeyRule;
import com.valor.vod.hotkey.common.tool.CollectionUtil;
import com.valor.vod.hotkey.common.tool.Constant;
import com.valor.vod.hotkey.common.tool.FastJsonUtils;
import com.valor.vod.hotkey.common.tool.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ConfigCenterStarter {
    private final ScheduledExecutorService scheduledExecutor;

    public ConfigCenterStarter(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    public void start() {
        this.fetchWorkerInfo();
        this.fetchRule(0L);
        this.startWatchRule();
        this.startWatchHotKey();
    }

    private void fetchExistHotKey() {
        JdLogger.info(this.getClass(), "--- begin fetch exist hotKey from etcd ----");
        IConfigCenter configCenter = ConfigCenterFactory.configCenter();
        try {
            List kvDataList = configCenter.getKvDataPrefix("/jd/hotkeys/" + Context.APP_NAME);
            for (KvData kvData : kvDataList) {
                String key = kvData.getKey().replace("/jd/hotkeys/" + Context.APP_NAME + "/", "");
                HotKeyModel model = new HotKeyModel();
                model.setRemove(false);
                model.setKey(key);
                EventBusCenter.getInstance().post((Object)new ReceiveNewKeyEvent(model));
            }
        }
        catch (RuntimeException ex) {
            JdLogger.error(this.getClass(), "etcd connected fail. Check the etcd address!!!");
        }
    }

    private void fetchWorkerInfo() {
        this.scheduledExecutor.scheduleAtFixedRate(() -> {
            JdLogger.info(this.getClass(), "trying to connect to etcd and fetch worker info");
            this.fetch();
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private void fetch() {
        IConfigCenter configCenter = ConfigCenterFactory.configCenter();
        try {
            List kvs = configCenter.getKvDataPrefix("/jd/workers/" + Context.APP_NAME);
            if (CollectionUtil.isEmpty((Collection)kvs)) {
                kvs = configCenter.getKvDataPrefix("/jd/workers/" + Constant.DEFAULT);
            }
            if (CollectionUtil.isEmpty((Collection)kvs)) {
                JdLogger.warn(this.getClass(), "very important warn !!! workers ip info is null!!!");
            }
            ArrayList<String> addresses = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty((Collection)kvs)) {
                for (KvData kv : kvs) {
                    String ipPort = kv.getValue();
                    addresses.add(ipPort);
                }
            }
            JdLogger.info(this.getClass(), "worker info list is : " + addresses + ", now addresses is " + WorkerInfoHolder.getWorkers());
            this.notifyWorkerChange(addresses);
        }
        catch (RuntimeException ex) {
            JdLogger.error(this.getClass(), "etcd connected fail. Check the etcd address!!!");
        }
    }

    private void notifyWorkerChange(List<String> addresses) {
        EventBusCenter.getInstance().post((Object)new WorkerInfoChangeEvent(addresses));
    }

    private void notifyRuleChange(List<KeyRule> rules) {
        EventBusCenter.getInstance().post((Object)new KeyRuleInfoChangeEvent(rules));
    }

    private void startWatchHotKey() {
        IConfigCenter configCenter = ConfigCenterFactory.configCenter();
        configCenter.subscribe("/jd/hotkeys/" + Context.APP_NAME, new INotifyListener(){

            public void notifyDataChange(DataEvent event) throws Exception {
                ConfigCenterStarter.this.scheduledExecutor.submit(() -> {
                    JdLogger.info(this.getClass(), "--- begin watch hotKey change ----");
                    KvData kv = event.getKvData();
                    String key = kv.getKey().replace("/jd/hotkeys/" + Context.APP_NAME + "/", "");
                    if (EventType.DELETE == event.getType()) {
                        HotKeyModel model = new HotKeyModel();
                        model.setRemove(true);
                        model.setKey(key);
                        EventBusCenter.getInstance().post((Object)new ReceiveNewKeyEvent(model));
                    } else {
                        HotKeyModel model = new HotKeyModel();
                        model.setRemove(false);
                        String value = kv.getValue();
                        JdLogger.info(this.getClass(), "etcd receive new key : " + key + " --value:" + value);
                        if (Constant.DEFAULT_DELETE_VALUE.equals(value)) {
                            return;
                        }
                        model.setCreateTime(Long.parseLong(kv.getValue()));
                        model.setKey(key);
                        EventBusCenter.getInstance().post((Object)new ReceiveNewKeyEvent(model));
                    }
                });
            }
        });
    }

    private void fetchRule(long delaySecond) {
        this.scheduledExecutor.schedule(() -> {
            JdLogger.info(this.getClass(), "trying to fetch rule info");
            boolean success = this.fetchRuleFromEtcd();
            if (success) {
                this.fetchExistHotKey();
            } else {
                this.fetchRule(5L);
            }
        }, delaySecond, TimeUnit.SECONDS);
    }

    private boolean fetchRuleFromEtcd() {
        IConfigCenter configCenter = ConfigCenterFactory.configCenter();
        try {
            ArrayList<KeyRule> ruleList = new ArrayList();
            String rules = configCenter.get("/jd/rules/" + Context.APP_NAME);
            if (StrUtil.isEmpty((CharSequence)rules)) {
                JdLogger.warn(this.getClass(), "rule is empty");
                this.notifyRuleChange(ruleList);
                return true;
            }
            ruleList = FastJsonUtils.toList((String)rules, KeyRule.class);
            this.notifyRuleChange(ruleList);
            return true;
        }
        catch (RuntimeException ex) {
            JdLogger.error(this.getClass(), "etcd connected fail. Check the etcd address!!!");
            return false;
        }
        catch (Exception e) {
            JdLogger.error(this.getClass(), "fetch rule failure, please check the rule info in etcd");
            return true;
        }
    }

    private void startWatchRule() {
        IConfigCenter configCenter = ConfigCenterFactory.configCenter();
        configCenter.subscribe("/jd/rules/" + Context.APP_NAME, new INotifyListener(){

            public void notifyDataChange(DataEvent event) throws Exception {
                ConfigCenterStarter.this.scheduledExecutor.submit(() -> {
                    JdLogger.info(this.getClass(), "--- begin watch rule change ----");
                    ConfigCenterStarter.this.fetchRuleFromEtcd();
                });
            }
        });
    }
}

