/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.core.worker;

import com.valor.vod.hotkey.client.core.worker.WorkerInfoHolder;
import com.valor.vod.hotkey.client.log.JdLogger;
import com.valor.vod.hotkey.client.netty.NettyClient;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class WorkerRetryConnector {
    private ScheduledExecutorService scheduledExecutor;

    public WorkerRetryConnector(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    public void retryConnectWorkers() {
        this.scheduledExecutor.scheduleAtFixedRate(WorkerRetryConnector::reConnectWorkers, 30L, 30L, TimeUnit.SECONDS);
    }

    private static void reConnectWorkers() {
        List<String> nonList = WorkerInfoHolder.getNonConnectedWorkers();
        if (nonList.size() == 0) {
            return;
        }
        JdLogger.info(WorkerRetryConnector.class, "trying to reConnect to these workers :" + nonList);
        NettyClient.getInstance().connect(nonList);
    }
}

