/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.netty;

import com.valor.vod.hotkey.client.Context;
import com.valor.vod.hotkey.client.callback.ReceiveNewKeyEvent;
import com.valor.vod.hotkey.client.core.eventbus.EventBusCenter;
import com.valor.vod.hotkey.client.log.JdLogger;
import com.valor.vod.hotkey.client.netty.event.ChannelInactiveEvent;
import com.valor.vod.hotkey.common.model.HotKeyModel;
import com.valor.vod.hotkey.common.model.HotKeyMsg;
import com.valor.vod.hotkey.common.model.typeenum.MessageType;
import com.valor.vod.hotkey.common.tool.CollectionUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Collection;

@ChannelHandler.Sharable
public class NettyClientHandler
extends SimpleChannelInboundHandler<HotKeyMsg> {
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent idleStateEvent;
        if (evt instanceof IdleStateEvent && (idleStateEvent = (IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.writeAndFlush((Object)new HotKeyMsg(MessageType.PING, Context.APP_NAME));
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        JdLogger.info(((Object)((Object)this)).getClass(), "channelActive:" + ctx.name());
        ctx.writeAndFlush((Object)new HotKeyMsg(MessageType.APP_NAME, Context.APP_NAME));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.notifyWorkerChange(ctx.channel());
    }

    private void notifyWorkerChange(Channel channel) {
        EventBusCenter.getInstance().post((Object)new ChannelInactiveEvent(channel));
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, HotKeyMsg msg) {
        if (MessageType.PONG == msg.getMessageType()) {
            JdLogger.info(((Object)((Object)this)).getClass(), "heart beat");
            return;
        }
        if (MessageType.RESPONSE_NEW_KEY == msg.getMessageType()) {
            JdLogger.info(((Object)((Object)this)).getClass(), "receive new key : " + msg);
            if (CollectionUtil.isEmpty((Collection)msg.getHotKeyModels())) {
                return;
            }
            for (HotKeyModel model : msg.getHotKeyModels()) {
                EventBusCenter.getInstance().post((Object)new ReceiveNewKeyEvent(model));
            }
        }
    }
}

