package com.valor.vod.hotkey.common.configcenter;

import com.valor.vod.hotkey.common.tool.FastJsonUtils;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 配置中心属性配置
 *
 * @author Bruce Wu
 * @since 2022-12-28
 */
public class ConfigCenterCfg {
    /** 配置中心类型，默认etcd */
    private String type = "etcd";
    /** 地址列表，多个地址逗号隔开 */
    private String adders;
    /** 用户名 */
    private String username;
    /** 密码 */
    private String password;
    /** 其他属性 */
    private Map<String, Object> properties = new LinkedHashMap<>();

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAdders(String adders) {
        this.adders = adders;
    }

    public String getAdders() {
        return adders;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, Object> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public String toString() {
        return FastJsonUtils.convertObjectToJSON(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String type = "etcd";
        private String adders;
        private String username;
        private String password;
        private Map<String, Object> properties;

        private Builder() {}

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder adders(String adders) {
            this.adders = adders;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public ConfigCenterCfg build() {
            ConfigCenterCfg configCenterCfg = new ConfigCenterCfg();
            configCenterCfg.setType(type);
            configCenterCfg.setAdders(adders);
            configCenterCfg.setUsername(username);
            configCenterCfg.setPassword(password);
            if (properties != null) {
                configCenterCfg.setProperties(properties);
            }
            return configCenterCfg;
        }
    }
}
