package com.valor.vod.hotkey.common.configcenter;

import com.valor.vod.hotkey.common.configcenter.model.KvData;

import java.util.List;

/**
 * @author wuweifeng wrote on 2019-12-09
 * @version 1.0
 */
public interface IConfigCenter {

    /**
     * 存入key，value
     *
     * @param key
     * @param value
     */
    void put(String key, String value);

    /**
     * 添加key，value
     *
     * @param key
     * @param value
     */
    void add(String key, String value);

    /**
     * 存入key、value，和租约id
     *
     * @param key
     * @param value
     * @param leaseId
     */
    void put(String key, String value, long leaseId);

    /**
     * 删除一个lease
     *
     * @param leaseId
     */
    void revoke(long leaseId);

    /**
     * 存入key、value，和过期时间，单位是秒
     *
     * @param key
     * @param value
     * @param ttl
     * @return
     */
    long putAndGrant(String key, String value, long ttl);

    /**
     * 给key设置新的leaseId
     *
     * @param key
     * @param leaseId
     * @return
     */
    long setLease(String key, long leaseId);

    /**
     * 根据key删除
     *
     * @param key
     */
    void delete(String key);

    /**
     * 根据key，获取value
     *
     * @param key
     * @return
     */
    String get(String key);

    /**
     * 监听key
     *
     * @param key
     * @param listener
     */
    void subscribe(String key, INotifyListener listener);

    /**
     * 监听前缀为key的
     *
     * @param key
     * @param listener
     */
    void subscribePrefix(String key, INotifyListener listener);

    /**
     * 取消监听key
     *
     * @param key
     * @param listener
     */
    void unsubscribe(String key, INotifyListener listener);

    /**
     * 自动续约
     *
     * @param key key
     * @param value value
     * @param frequencySecs 续约频率，最小是4秒，默认是5秒
     * @param minTtl 最小存活时间，最小是2秒，默认是10秒
     * @return
     * @throws Exception
     */
    long keepAlive(String key, String value, int frequencySecs, int minTtl) throws Exception;

    /**
     * 构建一个可自动续约的lease
     *
     * @param frequencySecs
     * @param minTtl
     * @return
     * @throws Exception
     */
    long buildAliveLease(int frequencySecs, int minTtl) throws Exception;

    /**
     * 构建一个普通lease
     *
     * @param ttl ttl
     * @return
     */
    long buildNormalLease(long ttl);

    /**
     * 判断剩余的过期时间
     *
     * @param leaseId leaseId
     * @return
     */
    long timeToLive(long leaseId);

    KvData getKvData(String key);

    List<KvData> getKvDataPrefix(String key);
}
