package com.valor.vod.hotkey.common.configcenter.model;

import com.valor.vod.hotkey.common.tool.FastJsonUtils;

import java.util.EventObject;
/**
 * @author Bruce Wu
 * @since 2022-12-13
 */
public class DataEvent extends EventObject {

    private final KvData kvData;

    private final EventType type;

    public DataEvent(Object source, KvData kvData, EventType type) {
        super(source);
        this.kvData = kvData;
        this.type = type;
    }

    public KvData getKvData() {
        return kvData;
    }

    public EventType getType() {
        return type;
    }

    @Override
    public String toString() {
        return FastJsonUtils.convertObjectToJSON(this);
    }
}
