package com.valor.vod.hotkey.common.configcenter.model;

import com.valor.vod.hotkey.common.tool.FastJsonUtils;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author Bruce Wu
 * @since 2022-12-13
 */
public class KvData {
    /** key */
    private String key;
    /** value */
    private String value;
    /** 存活时间 ms */
    private long ttl = 0;
    /** 属性 */
    private Map<Object, Object> properties = new LinkedHashMap<>();

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public long getTtl() {
        return ttl;
    }

    public Map<Object, Object> getProperties() {
        return properties;
    }

    public void setProperties(Map<Object, Object> properties) {
        this.properties = properties;
    }

    public long getModRevision() {
        if (properties == null) {
            return 0L;
        }
        Object val = properties.get("modRevision");
        if (val == null) {
            return 0L;
        }
        return Long.parseLong(val.toString());
    }

    @Override
    public String toString() {
        return FastJsonUtils.convertObjectToJSON(this);
    }
}
