package com.valor.vod.hotkey.common.convert;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.*;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.LongAdder;

/**
 * @author qiujw wrote on 2021-06-29
 * @version 1.0
 */
public class LongAdderCodec implements ObjectSerializer, ObjectDeserializer {

    @Override
    public void write(
            JSONSerializer serializer,
            Object object,
            Object fieldName,
            Type fieldType,
            int features)
            throws IOException {
        SerializeWriter out = serializer.out;
        if (object instanceof Long) {
            out.writeLong(((Long) object));
        } else if (object instanceof LongAdder) {
            out.writeLong(((LongAdder) object).longValue());
        }
    }

    @Override
    public LongAdder deserialze(DefaultJSONParser parser, Type type, Object o) {
        long val = parser.getLexer().longValue();
        LongAdder adder = new LongAdder();
        adder.add(val);
        return adder;
    }

    @Override
    public int getFastMatchToken() {
        return 0;
    }
}
