/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.common.tool;

import com.valor.vod.hotkey.common.tool.CollectionUtil;
import com.valor.vod.hotkey.common.tool.Constant;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);
    private static final int RND_PORT_START = 30000;
    private static final int RND_PORT_RANGE = 10000;
    private static final int MIN_PORT = 1;
    private static final int MAX_PORT = 65535;
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^\\d{1,3}(\\.\\d{1,3}){3}\\:\\d{1,5}$");
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final Map<String, String> HOST_NAME_CACHE = new LinkedHashMap<String, String>(16);
    private static volatile InetAddress LOCAL_ADDRESS = null;
    private static final BitSet USED_PORT = new BitSet(65536);
    private static volatile String HOST_ADDRESS;

    public static int getRandomPort() {
        return 30000 + ThreadLocalRandom.current().nextInt(10000);
    }

    public static synchronized int getAvailablePort() {
        int randomPort = NetUtils.getRandomPort();
        return NetUtils.getAvailablePort(randomPort);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int getAvailablePort(int port) {
        if (port < 1) {
            return 1;
        }
        int i = port;
        while (i < 65535) {
            if (!USED_PORT.get(i)) {
                try (ServerSocket ignored = new ServerSocket(i);){
                    USED_PORT.set(i);
                    int n = i;
                    return n;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return port;
    }

    public static boolean isInvalidPort(int port) {
        return port < 1 || port > 65535;
    }

    public static boolean isValidAddress(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public static boolean isLocalHost(String host) {
        return host != null && (LOCAL_IP_PATTERN.matcher(host).matches() || host.equalsIgnoreCase(Constant.LOCALHOST_KEY));
    }

    public static boolean isAnyHost(String host) {
        return Constant.ANYHOST_VALUE.equals(host);
    }

    public static boolean isInvalidLocalHost(String host) {
        return host == null || host.length() == 0 || host.equalsIgnoreCase(Constant.LOCALHOST_KEY) || host.equals(Constant.ANYHOST_VALUE) || host.startsWith("127.");
    }

    public static boolean isValidLocalHost(String host) {
        return !NetUtils.isInvalidLocalHost(host);
    }

    public static InetSocketAddress getLocalSocketAddress(String host, int port) {
        return NetUtils.isInvalidLocalHost(host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
    }

    static boolean isValidV4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && IP_PATTERN.matcher(name).matches() && !Constant.ANYHOST_VALUE.equals(name) && !Constant.LOCALHOST_VALUE.equals(name);
    }

    static boolean isPreferIPV6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                logger.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    public static String getLocalHost() {
        if (HOST_ADDRESS != null) {
            return HOST_ADDRESS;
        }
        InetAddress address = NetUtils.getLocalAddress();
        if (address != null) {
            HOST_ADDRESS = address.getHostAddress();
            return HOST_ADDRESS;
        }
        return Constant.LOCALHOST_VALUE;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return Constant.LOCALHOST_KEY;
        }
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtils.getLocalAddress0();
        return localAddress;
    }

    private static Optional<InetAddress> toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (NetUtils.isPreferIPV6Address()) {
                return Optional.ofNullable(NetUtils.normalizeV6Address(v6Address));
            }
        }
        if (NetUtils.isValidV4Address(address)) {
            return Optional.of(address);
        }
        return Optional.empty();
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            NetworkInterface networkInterface = NetUtils.findNetworkInterface();
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                Optional<InetAddress> addressOp = NetUtils.toValidAddress(addresses.nextElement());
                if (!addressOp.isPresent()) continue;
                try {
                    if (!addressOp.get().isReachable(100)) continue;
                    return addressOp.get();
                }
                catch (IOException iOException) {
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Find network interface", e);
        }
        try {
            localAddress = InetAddress.getLocalHost();
            Optional<InetAddress> addressOp = NetUtils.toValidAddress(localAddress);
            if (addressOp.isPresent()) {
                return addressOp.get();
            }
        }
        catch (Throwable e) {
            logger.warn("Find network interface", e);
        }
        return localAddress;
    }

    private static boolean ignoreNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        return networkInterface == null || networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp();
    }

    private static List<NetworkInterface> getValidNetworkInterfaces() throws SocketException {
        LinkedList<NetworkInterface> validNetworkInterfaces = new LinkedList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (NetUtils.ignoreNetworkInterface(networkInterface)) continue;
            validNetworkInterfaces.add(networkInterface);
        }
        return validNetworkInterfaces;
    }

    public static boolean isPreferredNetworkInterface(NetworkInterface networkInterface) {
        String preferredNetworkInterface = System.getProperty(Constant.HK_PREFERRED_NETWORK_INTERFACE);
        return Objects.equals(networkInterface.getDisplayName(), preferredNetworkInterface);
    }

    public static NetworkInterface findNetworkInterface() {
        List<Object> validNetworkInterfaces = Collections.emptyList();
        try {
            validNetworkInterfaces = NetUtils.getValidNetworkInterfaces();
        }
        catch (Throwable e) {
            logger.warn("Get valid notwork interfaces error", e);
        }
        NetworkInterface result = null;
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            if (!NetUtils.isPreferredNetworkInterface(networkInterface)) continue;
            result = networkInterface;
            break;
        }
        if (result == null) {
            block5: for (NetworkInterface networkInterface : validNetworkInterfaces) {
                ArrayList<InetAddress> addresses = Collections.list(networkInterface.getInetAddresses());
                logger.info("Network interface -> {}, addresses -> {}", (Object)networkInterface, addresses);
                for (InetAddress address : addresses) {
                    Optional<InetAddress> addressOp = NetUtils.toValidAddress(address);
                    if (!addressOp.isPresent()) continue;
                    try {
                        if (!addressOp.get().isReachable(100)) continue;
                        result = networkInterface;
                        continue block5;
                    }
                    catch (IOException iOException) {
                    }
                }
            }
        }
        if (result == null) {
            result = (NetworkInterface)CollectionUtil.first(validNetworkInterfaces);
        }
        return result;
    }

    public static String getHostName(String address) {
        try {
            String hostname;
            int i = address.indexOf(58);
            if (i > -1) {
                address = address.substring(0, i);
            }
            if ((hostname = HOST_NAME_CACHE.get(address)) != null && hostname.length() > 0) {
                return hostname;
            }
            InetAddress inetAddress = InetAddress.getByName(address);
            if (inetAddress != null) {
                hostname = inetAddress.getHostName();
                HOST_NAME_CACHE.put(address, hostname);
                return hostname;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return address;
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static String toAddressString(InetSocketAddress address) {
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }

    public static InetSocketAddress toAddress(String address) {
        int port;
        String host;
        int i = address.indexOf(58);
        if (i > -1) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
            port = 0;
        }
        return new InetSocketAddress(host, port);
    }
}

