/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.common.tool.flush;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"flushUtil");

    public static void flush(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (channelHandlerContext.channel().isWritable()) {
            channelHandlerContext.channel().writeAndFlush((Object)byteBuf).addListener(future -> {
                if (!future.isSuccess()) {
                    logger.warn("flush error " + future.cause().getMessage());
                }
            });
        } else {
            try {
                channelHandlerContext.channel().writeAndFlush((Object)byteBuf).sync();
            }
            catch (InterruptedException e) {
                logger.error("flush error " + e.getMessage());
            }
        }
    }
}

