//package com.valor.vod.hotkey.configcenter.nacos;
//
//import com.alibaba.nacos.api.config.ConfigService;
//import com.alibaba.nacos.api.exception.NacosException;
//import com.google.protobuf.ByteString;
//import com.ibm.etcd.api.KeyValue;
//import com.ibm.etcd.client.kv.KvClient;
//import com.valor.vod.hotkey.common.configcenter.IConfigCenter;
//
//import java.net.URLDecoder;
//import java.util.ArrayList;
//import java.util.Arrays;
//import java.util.List;
//import java.util.concurrent.atomic.AtomicBoolean;
//import java.util.stream.Collectors;
//
///**
// * @className: NacosConfigCenter
// * @description: TODO 类描述
// * @author: niaonao
// * @date: 2022/12/8
// */
//public class NacosConfigCenter implements IConfigCenter {
//
//    private ConfigService configService;
//
//    private String dataId;
//
//    private String group;
//
//    public NacosConfigCenter(ConfigService configService, String dataId, String group) {
//        this.configService = configService;
//        this.dataId = dataId;
//        this.group = group;
//    }
//
//    @Override
//    public void put(String key, String value) {
//        try {
//            List<KeyValue> valueList = getValueList("");
//            List<String> collect = new ArrayList<>();
//            AtomicBoolean isNew = new AtomicBoolean(true);
//            valueList.forEach(
//                    (item) -> {
//                        if (item.getKey().toStringUtf8().startsWith(key)) {
//                            collect.add(item.getKey().toStringUtf8() + "=" + value);
//                            isNew.set(false);
//                        } else {
//                            collect.add(
//                                    item.getKey().toStringUtf8()
//                                            + "="
//                                            + item.getValue().toStringUtf8());
//                        }
//                    });
//            if (isNew.get()) {
//                collect.add(key + "=" + value);
//            }
//            String newLine = System.getProperty("line.separator");
//            String join = String.join(newLine, collect);
//            configService.publishConfig(dataId, group, join);
//        } catch (NacosException e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//    @Override
//    public void add(String key, String value) {
//        try {
//            List<KeyValue> valueList = getValueList("");
//            List<String> collect = new ArrayList<>();
//            valueList.forEach(
//                    (item) -> {
//                        collect.add(
//                                item.getKey().toStringUtf8()
//                                        + "="
//                                        + item.getValue().toStringUtf8());
//                    });
//            collect.add(key + "=" + value);
//            String newLine = System.getProperty("line.separator");
//            String join = String.join(newLine, collect);
//            configService.publishConfig(dataId, group, join);
//        } catch (NacosException e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//    @Override
//    public void put(String key, String value, long leaseId) {
//        put(key, value);
//    }
//
//    @Override
//    public void revoke(long leaseId) {}
//
//    @Override
//    public long putAndGrant(String key, String value, long ttl) {
//        return 0;
//    }
//
//    @Override
//    public long setLease(String key, long leaseId) {
//        return 0;
//    }
//
//    @Override
//    public void delete(String key) {
//        try {
//            List<KeyValue> valueList = getValueList("");
//            List<String> collect = new ArrayList<>();
//            valueList.forEach(
//                    (item) -> {
//                        if (!item.getKey().toStringUtf8().startsWith(key)) {
//                            collect.add(
//                                    item.getKey().toStringUtf8()
//                                            + "="
//                                            + item.getValue().toStringUtf8());
//                        }
//                    });
//            String newLine = System.getProperty("line.separator");
//            String join = String.join(newLine, collect);
//            configService.publishConfig(dataId, group, join);
//        } catch (NacosException e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//    @Override
//    public void deleteByValue(String key, String value) {
//        try {
//            List<KeyValue> valueList = getValueList("");
//            List<String> collect = new ArrayList<>();
//            valueList.forEach(
//                    (item) -> {
//                        if (!item.getValue().toStringUtf8().equals(URLDecoder.decode(value))) {
//                            collect.add(
//                                    item.getKey().toStringUtf8()
//                                            + "="
//                                            + item.getValue().toStringUtf8());
//                        }
//                    });
//            String newLine = System.getProperty("line.separator");
//            String join = String.join(newLine, collect);
//            configService.publishConfig(dataId, group, join);
//        } catch (NacosException e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//    @Override
//    public String get(String key) {
//        return null;
//    }
//
//    @Override
//    public List<KeyValue> getPrefix(String key) {
//        try {
//            return getValueList(key);
//        } catch (NacosException e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//    @Override
//    public KvClient.WatchIterator subscribe(String key) {
//        return null;
//    }
//
//    @Override
//    public KvClient.WatchIterator subscribePrefix(String key) {
//        return null;
//    }
//
//    @Override
//    public long keepAlive(String key, String value, int frequencySecs, int minTtl)
//            throws Exception {
//        return 0;
//    }
//
//    @Override
//    public long buildAliveLease(int frequencySecs, int minTtl) throws Exception {
//        return 0;
//    }
//
//    @Override
//    public long buildNormalLease(long ttl) {
//        return 0;
//    }
//
//    @Override
//    public long timeToLive(long leaseId) {
//        return 0;
//    }
//
//    @Override
//    public KeyValue getKv(String key) {
//        try {
//            List<KeyValue> collect = getValueList(key);
//            return collect.isEmpty() ? null : collect.get(0);
//        } catch (NacosException e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//    private List<KeyValue> getValueList(String key) throws NacosException {
//        String config = configService.getConfig(dataId, group, 3000);
//        String[] split = config.split("\\R");
//        return Arrays.stream(split)
//                .filter(item -> item.startsWith(key))
//                .map(
//                        item -> {
//                            String[] configSplit = item.split("=");
//                            return KeyValue.newBuilder()
//                                    .setKey(ByteString.copyFromUtf8(configSplit[0]))
//                                    .setValue(ByteString.copyFromUtf8(configSplit[1]))
//                                    .build();
//                        })
//                .collect(Collectors.toList());
//    }
//}
