package com.valor.vod.account.model.req;

import com.valor.vod.account.tools.ECallerType;
import com.valor.vod.api.AbstractPrintable;
import com.valor.vod.api.model.user.EUserType;
import org.apache.commons.lang3.StringUtils;

/**
 * Account Base req
 *
 * @author Tom
 * @since 2021-07-06
 */
public class AccountBaseReq extends AbstractPrintable {
    protected String email;
    private int debug = 0;
    /** app appVer */
    private long appVer = -1;
    /** activate key */
    private String actKey = "";
    /** session key */
    private String sessionKey = "";
    /** token */
    private String token = "";
    /** device id */
    private String did = "";
    /** user id */
    private long uid = -1;
    /** user id */
    private long uid2 = -1;
    /** language 格式为:en_US的形式 */
    private String lang = "en_US";
    /** 国家代码 */
    private String region = "us";
    /** language */
    private String language = "en";
    /** Web language. */
    private String langWeb = "en";
    /** 客户端IP */
    private String clientIp = "";
    /** 客户端region */
    private String clientRegion = "";
    /** 用户属性 */
    private long userProps = 0;
    /** 终端用户Ip */
    private String endUserIp = "";
    /** 终端用户区域 */
    private String endUserRegion = "";

    private String password = "";
    /** 客户端类型1:web 2:mfc app */
    private int clientType = 0;

    private String accountId = "";
    private long accountId1 = -1L;
    private int accountType = -1;
    private int userType = EUserType.EMAIL.getCode();

    /** 0:normal 1:dataStatus */
    private int callerType = ECallerType.NORMAL.ordinal();

    private int serviceType;
    /** 登录ID */
    private String loginId;
    /** 区域ID */
    private String areaId;

    private Integer accountLoginType = -1;
    /** 过期时间戳 */
    private long expireTs = 0;
    /** 设备限制数 */
    private int deviceLimit = 1;
    /** 套餐名称 */
    private String product;
    /** 套餐id */
    private long productId;
    /** HOT2.1， 鉴权中心系统类型 hot_live:0,tve_web:101,redplaybox:102,mfcbox:103 */
    private Integer systemType = 0;
    /** 是否检查绑定 */
    private Integer isNeedCheckBinding = 1;
    /** 是否校验密码 */
    private Integer checkPassword = 1;
    /** 是否校验状态 */
    private int checkStatus = 1;

    private String st;
    private long vendorId;
    /** 型号,如B8;B9 */
    private String model;
    /** 品牌 */
    private String brand;

    private String launcherAppId;
    private Integer actionType = 0;
    private String cpuId;
    private String imeiId;
    private String client;
    // vod
    /** 是否查询子账号 */
    private boolean isSearchSubAccount = true;
    /** 是否第三方登录 */
    private boolean thirdLogin = false;
    /** 来源系统 */
    private Integer sourceSystemCode;
    /** appId */
    private String appId;
    /** 如果设备账户信息没有更新，更新设备账户信息 */
    private Boolean queryUserInfo = false;

    private boolean searchChannelVendor = false;
    /** 0-BOX 1-MOBILE. for mfc */
    private Integer appType;
    private String sourceId;

    public String getLoginId() {
        if (StringUtils.isBlank(loginId)) {
            return getEmail();
        }
        return loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public int getCallerType() {
        return callerType;
    }

    public void setCallerType(int callerType) {
        this.callerType = callerType;
    }

    public long getAccountId1() {
        return accountId1;
    }

    public void setAccountId1(long accountId1) {
        this.accountId1 = accountId1;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int getClientType() {
        return clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public int getDebug() {
        return debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public long getAppVer() {
        return appVer;
    }

    public void setAppVer(long appVer) {
        this.appVer = appVer;
    }

    public String getActKey() {
        return actKey;
    }

    public void setActKey(String actKey) {
        this.actKey = actKey;
    }

    public String getSessionKey() {
        return sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public long getUid() {
        return uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public long getUid2() {
        return uid2;
    }

    public void setUid2(long uid2) {
        this.uid2 = uid2;
    }

    public String getLang() {
        return lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getClientRegion() {
        return clientRegion;
    }

    public void setClientRegion(String clientRegion) {
        this.clientRegion = clientRegion;
    }

    public long getUserProps() {
        return userProps;
    }

    public void setUserProps(long userProps) {
        this.userProps = userProps;
    }

    public String getEndUserIp() {
        return endUserIp;
    }

    public void setEndUserIp(String endUserIp) {
        this.endUserIp = endUserIp;
    }

    public String getEndUserRegion() {
        return endUserRegion;
    }

    public void setEndUserRegion(String endUserRegion) {
        this.endUserRegion = endUserRegion;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public int getAccountType() {
        return accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public String getLangWeb() {
        return langWeb;
    }

    public void setLangWeb(String langWeb) {
        this.langWeb = langWeb;
    }

    public int getServiceType() {
        return serviceType;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public Integer getAccountLoginType() {
        return accountLoginType;
    }

    public void setAccountLoginType(Integer accountLoginType) {
        this.accountLoginType = accountLoginType;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getUserType() {
        return userType;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public long getVendorId() {
        return vendorId;
    }

    public void setVendorId(long vendorId) {
        this.vendorId = vendorId;
    }

    public long getExpireTs() {
        return expireTs;
    }

    public void setExpireTs(long expireTs) {
        this.expireTs = expireTs;
    }

    public int getDeviceLimit() {
        return deviceLimit;
    }

    public void setDeviceLimit(int deviceLimit) {
        this.deviceLimit = deviceLimit;
    }

    public String getProduct() {
        return product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public long getProductId() {
        return productId;
    }

    public void setProductId(long productId) {
        this.productId = productId;
    }

    public Integer getCheckPassword() {
        return checkPassword;
    }

    public void setCheckPassword(Integer checkPassword) {
        this.checkPassword = checkPassword;
    }

    public void setCheckStatus(int checkStatus) {
        this.checkStatus = checkStatus;
    }

    public int getCheckStatus() {
        return checkStatus;
    }

    public Integer getSystemType() {
        return systemType;
    }

    public void setSystemType(Integer systemType) {
        this.systemType = systemType;
    }

    public String getSt() {
        return st;
    }

    public void setSt(String st) {
        this.st = st;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getLauncherAppId() {
        return launcherAppId;
    }

    public void setLauncherAppId(String launcherAppId) {
        this.launcherAppId = launcherAppId;
    }

    public Integer getIsNeedCheckBinding() {
        return isNeedCheckBinding;
    }

    public void setIsNeedCheckBinding(Integer isNeedCheckBinding) {
        this.isNeedCheckBinding = isNeedCheckBinding;
    }

    public Integer getActionType() {
        return actionType;
    }

    public void setActionType(Integer actionType) {
        this.actionType = actionType;
    }

    public String getCpuId() {
        return cpuId;
    }

    public void setCpuId(String cpuId) {
        this.cpuId = cpuId;
    }

    public String getImeiId() {
        return imeiId;
    }

    public void setImeiId(String imeiId) {
        this.imeiId = imeiId;
    }

    public String getClient() {
        return client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public boolean isSearchSubAccount() {
        return isSearchSubAccount;
    }

    public void setSearchSubAccount(boolean searchSubAccount) {
        isSearchSubAccount = searchSubAccount;
    }

    public boolean isThirdLogin() {
        return thirdLogin;
    }

    public void setThirdLogin(boolean thirdLogin) {
        this.thirdLogin = thirdLogin;
    }

    public Integer getSourceSystemCode() {
        return sourceSystemCode;
    }

    public void setSourceSystemCode(Integer sourceSystemCode) {
        this.sourceSystemCode = sourceSystemCode;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Boolean getQueryUserInfo() {
        return queryUserInfo;
    }

    public void setQueryUserInfo(Boolean queryUserInfo) {
        this.queryUserInfo = queryUserInfo;
    }

    public boolean isSearchChannelVendor() {
        return searchChannelVendor;
    }

    public void setSearchChannelVendor(boolean searchChannelVendor) {
        this.searchChannelVendor = searchChannelVendor;
    }

    public Integer getAppType() {
        return appType;
    }

    public void setAppType(Integer appType) {
        this.appType = appType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

}
