package com.valor.vod.account.model.req;

public enum EClientType {
    UNKNOWN(0), //未知
    WEB(1),     //web
    APP(2),     //mobile
    BOX(3);     //box


    int code;

    EClientType(int code) {
        this.code = code;
    }

    public static boolean isApp(int clientType) {
        return (clientType == BOX.ordinal() || clientType == APP.ordinal());
    }

    public static boolean isWeb(int clientType) {
        return (clientType == WEB.ordinal());
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
