package com.valor.vod.account.model.req;

import com.valor.vod.api.model.common.AbstractPrintable;
import com.valor.vod.api.model.user.ECardType;

/**
 * @author Gardfield
 * @title: LockCardReq
 * @projectName mfc-api-server
 * @description: lock account card or recharge card for panel (CC)
 * @date 10/19/2021
 */
public class LockCardReq extends AbstractPrintable {

    private String cardId;
    private Integer cardType= ECardType.ACCOUNT_CARD.getCode();
    private Long planId;
    private int lockFlag=1; // 1: lock; 0: unlock
    private int  isNeedUpdateCC=0; // 1: need update the card status in CC System;  0: no need to update CC
    private Long accountId=-1L;
    private Integer accountType=-1;
    private Long cardExpireTs;
    private String remark;

    public LockCardReq() {
    }

    public String getCardId() {
        return cardId;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }

    public Integer getCardType() {
        return cardType;
    }

    public void setCardType(Integer cardType) {
        this.cardType = cardType;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public int getLockFlag() {
        return lockFlag;
    }

    public void setLockFlag(int lockFlag) {
        this.lockFlag = lockFlag;
    }

    public int getIsNeedUpdateCC() {
        return isNeedUpdateCC;
    }

    public void setIsNeedUpdateCC(int isNeedUpdateCC) {
        this.isNeedUpdateCC = isNeedUpdateCC;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Long getCardExpireTs() {
        return cardExpireTs;
    }

    public void setCardExpireTs(Long cardExpireTs) {
        this.cardExpireTs = cardExpireTs;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String toString() {
        return "LockCardReq{" +
            "cardId='" + cardId + '\'' +
            ", cardType=" + cardType +
            ", planId=" + planId +
            ", lockFlag=" + lockFlag +
            ", isNeedUpdateCC=" + isNeedUpdateCC +
            ", accountId=" + accountId +
            ", accountType=" + accountType +
            ", cardExpireTs=" + cardExpireTs +
            ", remark='" + remark + '\'' +
            '}';
    }
}
