package com.valor.vod.account.stub;


import com.valor.vod.account.model.req.*;
import com.valor.vod.account.model.rsp.*;
import com.valor.vod.api.model.charge.ChargeDeviceDo;
import com.valor.vod.api.model.charge.ChargeInfoDo;
import com.valor.vod.api.model.common.response.ResponseMsgList;
import com.valor.vod.api.model.common.response.ResponseMsgSingle;
import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.api.model.user.SubAccountDo;
import com.valor.vod.api.model.usercenter.LoginMethodResult;
import com.valor.vod.common.web.response.ResponseSingle;

import java.util.List;
import java.util.Map;

public interface AccountStub {

    /**
     * 注册用户
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountRegRsp> registerAccount(Map<String, Object> stubProperties, AccountRegReq req);

    ResponseMsgSingle<AccountRegRsp> registerAccountV2(Map<String, Object> stubProperties, AccountRegReq req);

    /**
     * 查询用户信息
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountInfoRsp> queryAccount(Map<String, Object> stubProperties, AccountBaseReq req);

    ResponseMsgSingle<AccountInfoRsp> queryOldAccount(Map<String, Object> stubProperties, AccountBaseReq req);

    ResponseMsgSingle<AccountInfoRsp> queryUserV2(Map<String, Object> stubProperties, AccountBaseReq req);

    ResponseMsgSingle<AccountInfoRsp> checkAccount(Map<String, Object> stubProperties, AccountBaseReq req);

    /**
     * 查询用户信息
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountInfoRsp> queryAccountV1(Map<String, Object> stubProperties, AccountBaseReq req);

    /**
     * login
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountInfoRsp> loginAccount(Map<String, Object> stubProperties, AccountLoginReq req);


    ResponseMsgSingle<AccountInfoRsp> authLoginAccount(Map<String, Object> stubProperties, AccountAuthLoginReq req);


    /**
     * 重置密码
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus resetAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req);

    /**
     * 使用验证码重置密码
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus resetAccountPassword2(Map<String, Object> stubProperties, AccountPasswordReq req);


    /**
     * 修改密码
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus changeAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req);


    ResponseStatus changeAccountPlan(Map<String, Object> stubProperties, AccountPlanReq req);

    ResponseStatus cancelRenewal(Map<String, Object> stubProperties, AccountPlanReq req);

    ResponseMsgSingle<AccountInfoRsp> createAccount(Map<String, Object> stubProperties, AccountRegReq req);

    /**
     * 查询用户设备
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgList<AccountDevice> queryAccountDevice(Map<String, Object> stubProperties, AccountBaseReq req);


    /**
     * 直接修改用户的服务时长，不通过支付，用于CRM系统
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus modifyUserBiz(Map<String, Object> stubProperties, ModifyAccountBizReq req);

    /**
     * Activate Account
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus activateAccount(Map<String, Object> stubProperties, AccountRegReq req);

    /**
     * bindEmail
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus bindEmail(Map<String, Object> stubProperties, AccountBaseReq req);

    ResponseStatus bindEmailV2(Map<String, Object> stubProperties, AccountBaseReq req);


    /**
     * activateEmailBindind
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus activateEmailBinding(Map<String, Object> stubProperties, AccountBaseReq req);

    /**
     * query email binding info
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<EmailBindingRsp> checkEmailBinding(Map<String, Object> stubProperties, AccountBaseReq req);


    /**
     * set add cloud flag
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus setAddCloudFlag(Map<String, Object> stubProperties, AccountBaseReq req);


    /**
     * 查询登录方式
     * @param req
     * @return
     */
    ResponseMsgSingle<LoginMethodResult> queryLoginMethod(AccountQueryLoginMethodReq req);

    ResponseMsgSingle<ChargeDeviceDo> activateDevice(AccountBaseReq req);

    ResponseMsgSingle<ChargeInfoDo> userChargeQueryActiveState(AccountBaseReq req);

    ResponseMsgSingle<AccountBaseInfoResp> queryAccountBaseInfoByLoginId(AccountBaseReq req);

    ResponseMsgSingle<List<SubAccountDo>> getSubAccount(BasicSubAccountReq req);

    ResponseStatus delSubAccount(BasicSubAccountReq req);

    ResponseMsgSingle<AccountBaseInfoResp> userChargeConfirmActiveState(AccountBaseReq req);

    /**
     * 查询绑定账户（邮箱或手机）信息
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountInfoRsp> queryBindUser(Map<String, Object> stubProperties, AccountBaseReq req);

    /**
     * 创建特殊渠道下的账号
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountBaseInfoResp> createChannelUser(Map<String, Object> stubProperties, AccountActiveReq req);

    /**
     * 根据账户id查询账户信息
     * @param accountUserInfoReq
     * @return
     */
    ResponseMsgSingle<AccountBaseInfoResp> queryAccountBaseInfoByAccountId(AccountUserInfoReq accountUserInfoReq);

    ResponseMsgSingle<AccountBaseInfoResp> queryAccountBaseInfoByDeviceLogin(DeviceLoginReq req);

    /**
     * set binding tips flag
     *
     * @param stubProperties
     * @param accountId
     * @return
     */
    ResponseStatus setBindingTipsFlag(Map<String, Object> stubProperties, Long accountId);

    /**
     * 查询设备userInfo信息
     * @param req
     * @return
     */

    ResponseMsgSingle<AccountBaseInfoResp> queryUserInfoByLoginId(AccountSearchByAccountIdReq req);

    /**
     * 扫码登录根据账户id查询账户信息
     * @param accountId
     * @param isRewing
     * @param isSearchSubAccount
     * @return
     */
    ResponseMsgSingle<AccountBaseInfoResp> queryAccountBaseInfoByAccountIdQR(Long accountId, boolean isRewing, boolean isSearchSubAccount, String appId, long appVer, String region);

    /**
     * 根据loginId，sourceSystemCode查询账户过期时间
     * @param loginId
     * @param SourceSystemCode
     * @return
     */
    public ResponseMsgSingle<Long> getAccountExpire(String loginId, Integer SourceSystemCode);

    /**
     * bindSubscribeEmail
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus subscribeEmailBindingV1(Map<String, Object> stubProperties, AccountBaseReq req);

    /**
     * querySubscribeEmail
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<SubscribeEmailBindingRsp>  querySubscribeEmailV1(Map<String, Object> stubProperties, AccountBaseReq req);

    /**
     * 设备使用充值码
     * @param rechargeDeviceReq
     * @return
     */
    public ResponseMsgSingle<ChargeDeviceDo> rechargeDevice(RechargeDeviceReq rechargeDeviceReq);

    /**
     * 更新用户property属性
     * @param req
     * @return
     */
    public ResponseStatus updateAccountProperty(AccountPropertyReq req);

    /**
     * 查询关联账号
     *
     * @param req
     * @return
     */
    ResponseMsgList<LinkAccountResp> queryLinkAccount(AccountBaseReq req);

    ResponseMsgSingle<AccountRegRsp> createDistributorAccount(DistributoAcccountCreateReq req);

    ResponseMsgSingle<DistributorAccountInfoRsp> queryDistributorAccount(QueryDistributorAccountReq req);

    /**
     * 新增或者更新登录方式
     *
     * @param req req
     * @return response
     */
    ResponseStatus saveLoginMethod(SaveLoginMethodReq req);

    /**
     * 初始化账号下登录方式的loginIdType
     *
     * @param req req
     * @return response
     */
    ResponseStatus initLoginIdType(InitLoginIdTypeReq req);

    /**
     * 根据条件查询登录方式
     *
     * @param req req
     * @return 登录方式列表
     */
    ResponseMsgList<LoginMethodDTO> queryLoginMethods(QueryLoginMethodsReq req);

    /**
     * 绑定前检查
     *
     * @param req req
     * @return 检查结果
     */
    ResponseSingle<CheckForBindRsp> checkForBind(CheckForBindReq req);
}
