package com.valor.vod.account.stub;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.valor.vod.account.model.req.*;
import com.valor.vod.account.model.rsp.*;
import com.valor.vod.api.model.charge.ChargeDeviceDo;
import com.valor.vod.api.model.charge.ChargeInfoDo;
import com.valor.vod.api.model.common.response.ResponseMsgList;
import com.valor.vod.api.model.common.response.ResponseMsgSingle;
import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.api.model.constant.response.HttpCode2;
import com.valor.vod.api.model.user.EAccountType;
import com.valor.vod.api.model.user.EActionType;
import com.valor.vod.api.model.user.SubAccountDo;
import com.valor.vod.api.model.usercenter.LoginMethodResult;
import com.valor.vod.common.web.aop.annotation.ExceptionConverter;
import com.valor.vod.common.web.response.ResponseSingle;
import com.valor.vod.common.web.tools.VodValidate;
import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;
import lombok.SneakyThrows;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccountStubImpl implements AccountStub {

    private static final Logger logger = LoggerFactory.getLogger(AccountStubImpl.class);
    private static final String API_URL_REGISTER_V1 = "/api/user3/register/v1";
    private static final String API_URL_REGISTER_V2 = "/api/user3/register/v2";
    private static final String API_URL_CANC_ELRENEWAL_V1 = "/api/user3/cancel/renewal/v1";
    private static final String API_URL_QUERY_V1 = "/api/user3/queryUser/v1";
    private static final String API_URL_QUERY_OLD_V1 = "/api/user3/queryOldUser/v1";
    private static final String API_URL_QUERY_V2 = "/api/user3/queryUser/v2";
    private static final String API_URL_CHECK_ACCOUNT_v1 = "/api/user3/checkAccountIfExist/v1";
    private static final String API_URL_QUERY_ACCOUNT_V1 = "/api/user3/queryAccount/v1";
    private static final String API_URL_LOGIN_V1 = "/api/user3/login/v1";
    private static final String API_URL_AUTH_LOGIN_V1 = "/api/user3/authLogin/v1";
    private static final String API_URL_CREATE_ACCOUNT_V1 = "/api/user3/create/v1";
    private static final String API_URL_QUERYDEVICE_V1 = "/api/user3/queryDevice/v1";
    private static final String API_URL_RESETPASSWORD_V1 = "/api/user3/resetPassword/v1";
    private static final String API_URL_RESETPASSWORD_V2 = "/api/user3/resetPassword/v2";
    private static final String API_URL_MODIFYPASSWORD_V1 = "/api/user3/modifyPassword/v1";
    private static final String API_URL_NOTIFICATIONPAYMENTS_V1 = "/api/user3/notification/payments/v1";
    private static final String API_URL_CANCELRENEWAL_V1 = "/api/user3/notification/cancel/renewal/v1";
    private static final String API_URL_MODIFY_USER_BIZ_V1 = "/api/user3/modifyUserBiz/v2";
    private static final String API_URL_ACTIVATE_V1 = "/api/user3/activate/v1";
    private static final String API_URL_SET_ADD_CLOUD_FLAG_V1 = "/api/user3/setAddCloudFlag/v1";
    private static final String API_URL_UPDATE_PLAN_V1 = "/api/user3/updatePlan/v1";
    private static final String API_URL_CREATE_EMAIL_BINDING_V1 = "/api/user3/emailBinding/create/v1";
    private static final String API_URL_CREATE_EMAIL_BINDING_V2 = "/api/user3/emailBinding/create/v2";
    private static final String API_URL_ACTIVATE_EMAIL_BINDING_V1 = "/api/user3/emailBinding/activate/v1";
    private static final String API_URL_QUERY_EMAIL_BINDING_V1 = "/api/user3/emailBinding/query/v1";
    private static final String API_URL_QUERY_LOGIN_METHOD_V1 = "/api/user3/queryLoginMethod/v1";
    private static final String API_URL_ACTIVE_DEVICE_V1 = "/api/user3/activeDevice/v1";
    private static final String API_URL_QUERY_ACTIVE_STATE_V1 = "/api/user3/queryactivestate/v1";
    private static final String API_URL_CONFIRM_ACTIVE_V1 = "/api/user3/confirmactivestate/v1";
    private static final String API_URL_QUERY_ACCOUNT_BASE_INFO_BY_LOGINID_V1 = "/api/user3/queryAccountBaseInfoByLoginId/v1";
    private static final String API_URL_QUERY_ACCOUNT_BASE_INFO_BY_ACCOUNTID_V1 = "/api/user3/queryAccountBaseInfoByAccountId/v1";
    private static final String API_URL_QUERY_SUB_ACCOUNT_V1 = "/api/account/listSub/forMigrate";
    private static final String API_URL_QUERY_AND_CREATE_SUB_ACCOUNT_V1 = "/api/account/admin/queryAndCreateSub";
    private static final String API_URL_QUERY_BINDUSER_V1 = "/api/user3/queryBindUser/v1";
    private static final String API_URL_CREATE_CHANNELUSER_V1 = "/api/user3/channelUser/v1";
    private static final String API_URL_SET_BINDING_TIPS_FLAG_V1 = "/api/user3/setBindingTipsFlag/v1";
    private static final String API_URL_GET_ACCOUNT_EXPIRETS = "/api/user3/accountExpireTs/v1";
    private static final String API_URL_CREATE_SUBSCRIBE_EMAIL_BINDING_V1 = "/api/user3/subscribeEmailBinding/create/v1";
    private static final String API_URL_QUERY_SUBSCRIBE_EMAIL_V1 = "/api/user3/subscribeEmailBinding/query/v1";
    private static final String API_URL_RECHARGE_DEVICE_V1 = "/api/user3/rechargeDevice/v1";
    private static final String API_URL_DISTRIBUTOR_ACCOUNT_CREATE_V1 = "/api/user3/distributorAccount/create/v1";
    private static final String API_URL_DISTRIBUTOR_ACCOUNT_QUERY_V1 = "/api/user3/distributorAccount/query/v1";

    private static final String API_URL_DEL_SUB_ACCOUNT = "/api/account/delSub";
    private static final String API_URL_UPDATE_ACCOUNT_PROPERTY_V1 = "/api/user3/updateAccountProperty/v1";
    private static final String API_URL_QUERY_LINK_ACCOUNT_V1 = "/api/user3/queryLinkAccount/v1";
    private static final String API_URL_SAVE_LOGIN_METHOD_V1 = "/api/account/loginMethod/save/v1";
    private static final String API_URL_INIT_LOGIN_ID_TYPE_V1 = "/api/account/loginMethod/loginIdType/init/v1";
    private static final String API_URL_QUERY_LOGIN_METHODS_V1 = "/api/account/loginMethod/query/v1";
    private static final String API_URL_CHECK_FOR_BIND_V1 = "/api/user3/checkForBind/v1";

    protected String host = ConfigTools3.getString("user3.api.host", "http://127.0.0.1:9712");
    // protected String host = ConfigTools3.getString("user3.api.host-dev", "http://127.0.0.1:9712");
    private int timeout = ConfigTools3.getInt("user3.api.timeout", 60 * 1000); //60s

    public AccountStubImpl(String host, int timeout) {
        this.host = host;
        this.timeout = timeout;
    }

    public AccountStubImpl(String host) {
        this.host = host;
    }

    public AccountStubImpl() {
    }

    private Object urlEncode(String encodeStr) {
        try {
            if (Objects.nonNull(encodeStr)) {
                return URLEncoder.encode(encodeStr, "UTF-8");
            }
        } catch (UnsupportedEncodingException e) {
            logger.error("URL encode error.[{}]", encodeStr, e);
        }
        return encodeStr;
    }

    @Override
    public ResponseMsgSingle<AccountRegRsp> registerAccount(Map<String, Object> stubProperties, AccountRegReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("userName", req.getUserName());
        dataMap.put("password", req.getPassword());
        dataMap.put("useVerificationCode", req.getUseVerificationCode());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        if (StringUtils.isNotEmpty(req.getAreaId())) {
            dataMap.put("areaId", req.getAreaId());
        }
        if (StringUtils.isNotEmpty(req.getLoginId())) {
            dataMap.put("loginId", req.getLoginId());
        }


        ResponseMsgSingle<AccountRegRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_REGISTER_V1, timeout, dataMap, new TypeReference<ResponseMsgSingle<AccountRegRsp>>() {
            });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountRegRsp> registerAccountV2(Map<String, Object> stubProperties, AccountRegReq req) {
        VodValidate.isTrue(StringUtils.containsNone(req.getUserName(), "+ /?%#&="),
            req.getLanguage(), null, HttpCode2.SYS_CODE_AUTH, HttpCode2.RET_INVALID_PARAM,
            "Username is not allowed to contain characters '+ /?%#&=' etc.");

        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("userName", req.getUserName());
        dataMap.put("password", req.getPassword());
        dataMap.put("useVerificationCode", req.getUseVerificationCode());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        dataMap.put("sourceId", req.getSourceId());
        if (StringUtils.isNotEmpty(req.getAreaId())) {
            dataMap.put("areaId", req.getAreaId());
        }
        if (StringUtils.isNotEmpty(req.getLoginId())) {
            dataMap.put("loginId", req.getLoginId());
        }

        ResponseMsgSingle<AccountRegRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_REGISTER_V2, timeout, dataMap, new TypeReference<ResponseMsgSingle<AccountRegRsp>>() {
            });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus cancelRenewal(Map<String, Object> stubProperties, AccountPlanReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);

        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("accountType", req.getAccountType());
        ResponseMsgSingle<AccountRegRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_CANC_ELRENEWAL_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountRegRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> createAccount(Map<String, Object> stubProperties, AccountRegReq req) {

        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("userName", req.getUserName());
        dataMap.put("expireTs", req.getExpireTs());
        dataMap.put("deviceLimit", req.getDeviceLimit());
        dataMap.put("systemType", req.getSystemType());
        dataMap.put("product", req.getProduct());
        dataMap.put("productId", req.getProductId());
        dataMap.put("userType", req.getUserType());
        dataMap.put("isNeedCheckBinding", req.getIsNeedCheckBinding());
        dataMap.put("did", req.getDid());
        dataMap.put("cpuId", req.getCpuId());
        dataMap.put("imeiId", req.getImeiId());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("appId", req.getAppId());
        dataMap.put("region", req.getRegion());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_CREATE_ACCOUNT_V1, timeout, dataMap, new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
            });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> queryAccount(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> queryOldAccount(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_OLD_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> queryUserV2(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("password", req.getPassword());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        dataMap.put("checkPassword", req.getCheckPassword());
        // 鉴权中心分发过来的系统类型
        dataMap.put("systemType", req.getSystemType());
        dataMap.put("isNeedCheckBinding", req.getIsNeedCheckBinding());
        dataMap.put("actionType", req.getActionType());
        dataMap.put("clientType", req.getClientType());
        // 是否第三方登录
        dataMap.put("thirdLogin", req.isThirdLogin());
        // 是否需要查询子账号,默认为true
        dataMap.put("isSearchSubAccount", req.isSearchSubAccount());
        dataMap.put("appId", req.getAppId());
        dataMap.put("region", req.getRegion());
        dataMap.put("client", req.getClient());
        dataMap.put("checkStatus", req.getCheckStatus());

        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_V2, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> checkAccount(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_CHECK_ACCOUNT_v1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> queryAccountV1(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("callerType", req.getCallerType());
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("appVer", req.getAppVer());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_ACCOUNT_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> loginAccount(Map<String, Object> stubProperties, AccountLoginReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("password", req.getPassword());
        dataMap.put("appBizExpire", req.getAppBizExpire());
        dataMap.put("model", req.getModel());
        dataMap.put("productId", req.getProductId());
        dataMap.put("plan", req.getPlan());
        dataMap.put("needAddCloud", req.isNeedAddCloud());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("vendorId", req.getVendorId());
        dataMap.put("mac", req.getDid());
        dataMap.put("cpuId", req.getCpuId());
        dataMap.put("imeiId", req.getImeiId());
        dataMap.put("client", req.getClient());
        dataMap.put("transferServiceTimeFlag", req.isTransferServiceTimeFlag());
        dataMap.put("langWeb", req.getLangWeb());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        dataMap.put("thirdLogin", req.isThirdLogin());
        dataMap.put("login", req.isLogin());
        dataMap.put("appId", req.getAppId());
        dataMap.put("region", req.getRegion());
        dataMap.put("systemType", req.getSystemType());
        dataMap.put("searchChannelVendor", req.isSearchChannelVendor());
        dataMap.put("serviceType", req.getServiceType());
        if (req.isSearchChannelVendor()) {
            dataMap.put("appType", req.getAppType());
        }
        if(StringUtils.isNotBlank(req.getAccountId())) {
            dataMap.put("accountId", req.getAccountId());
        }
        dataMap.put("activityId", req.getActivityId());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_LOGIN_V1, timeout, dataMap,

                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> authLoginAccount(Map<String, Object> stubProperties, AccountAuthLoginReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("password", req.getPassword());
        dataMap.put("authorizedSystem", req.getAuthorizedSystem());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("checkPassword", req.getCheckPassword());

        dataMap.put("systemType", req.getSystemType());
        dataMap.put("bType",req.getbType());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {

            rsp = invoke(host, API_URL_AUTH_LOGIN_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<EmailBindingRsp> checkEmailBinding(Map<String, Object> stubProperties, AccountBaseReq
        req) {

        Map<String, Object> dataMap = Maps.newHashMap();

        dataMap.put("accountId", req.getAccountId1());
        dataMap.put("accountType", req.getAccountType());

        ResponseMsgSingle<EmailBindingRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_EMAIL_BINDING_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<EmailBindingRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;

    }

    @Override
    public ResponseStatus activateEmailBinding(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();

        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("email", urlEncode(req.getEmail()));
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_ACTIVATE_EMAIL_BINDING_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus bindEmail(Map<String, Object> stubProperties, AccountBaseReq req) {

        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();

        dataMap.put("endUserIp", req.getEndUserIp());
        dataMap.put("endUserRegion", req.getEndUserRegion());
        dataMap.put("clientType", req.getClientType());
        dataMap.put("did", req.getDid());
        dataMap.put("accountId", Long.valueOf(req.getAccountId1()));
        dataMap.put("accountId1", Long.valueOf(req.getAccountId1()));
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("activityId", urlEncode(req.getEmail()));
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_CREATE_EMAIL_BINDING_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus bindEmailV2(Map<String, Object> stubProperties, AccountBaseReq req) {

        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();

        dataMap.put("endUserIp", req.getEndUserIp());
        dataMap.put("endUserRegion", req.getEndUserRegion());
        dataMap.put("clientType", req.getClientType());
        dataMap.put("did", req.getDid());
        // dataMap.put("accountId", req.getAccountId());
        dataMap.put("accountId", Long.valueOf(req.getAccountId1()));
        dataMap.put("accountId1", Long.valueOf(req.getAccountId1()));
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("activityId", urlEncode(req.getEmail()));
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_CREATE_EMAIL_BINDING_V2, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus resetAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("loginId", urlEncode(req.getEmail()));
        dataMap.put("newPassword", req.getNewPassword());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_RESETPASSWORD_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus resetAccountPassword2(Map<String, Object> stubProperties, AccountPasswordReq req) {
        updateStubInfo(stubProperties); //todo remove unnecessary params
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        //  todo 统一修改参数
        String loginId = req.getEmail();
        if (!Strings.isNullOrEmpty(req.getLoginId())) {
            loginId = req.getLoginId();
        }
        dataMap.put("loginId", urlEncode(loginId));
        dataMap.put("newPassword", req.getNewPassword());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_RESETPASSWORD_V2, timeout, dataMap,
                new TypeReference<ResponseStatus>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus changeAccountPlan(Map<String, Object> stubProperties, AccountPlanReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("uid", req.getUid());
        dataMap.put("productId", req.getProductId());
        dataMap.put("paymentId", req.getPaymentId());
        dataMap.put("serviceType", req.getServiceType());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_UPDATE_PLAN_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;


    }

    @Override
    public ResponseStatus changeAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("loginId", urlEncode(req.getEmail()));
        dataMap.put("oldPassword", req.getOldPassword());
        dataMap.put("newPassword", req.getNewPassword());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_MODIFYPASSWORD_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgList<AccountDevice> queryAccountDevice(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("uid", req.getUid());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        dataMap.put("loginId", urlEncode(req.getLoginId()));

        ResponseMsgList<AccountDevice> rsp = new ResponseMsgList<>();
        try {
            rsp = invoke(host, API_URL_QUERYDEVICE_V1, timeout, dataMap,
                new TypeReference<ResponseMsgList<AccountDevice>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus modifyUserBiz(Map<String, Object> stubProperties, ModifyAccountBizReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("account", Strings.nullToEmpty(req.getAccount()));
        dataMap.put("serviceDays", req.getServiceDays());
        dataMap.put("action", req.getAction());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("expireTs", req.getExpireTs());
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("loginId", Strings.nullToEmpty(req.getLoginId()));
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_MODIFY_USER_BIZ_V1, timeout, dataMap,
                new TypeReference<ResponseStatus>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountRegRsp> activateAccount(Map<String, Object> stubProperties, AccountRegReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
//        dataMap.put("sourceSystemCode", req.getSourceSystemCode());
        dataMap.put("loginId", req.getEmail());
        ResponseMsgSingle<AccountRegRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_ACTIVATE_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountRegRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus setAddCloudFlag(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("accountId1", req.getAccountId1());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_SET_ADD_CLOUD_FLAG_V1, timeout, dataMap,
                new TypeReference<ResponseStatus>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<LoginMethodResult> queryLoginMethod(AccountQueryLoginMethodReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("loginId", Strings.nullToEmpty(req.getLoginId()));
        dataMap.put("language", req.getLanguage());
        dataMap.put("appVer", String.valueOf(req.getAppVer()));
        // mfc. 智向渠道
        dataMap.put("channelId", req.getChannelId());
        dataMap.put("channelDeviceType", urlEncode(req.getChannelDeviceType()));
        dataMap.put("vendorCode", req.getVendorCode());
        // mfc. uota渠道
        dataMap.put("preVendorId", req.getPreVendorId());
        dataMap.put("uid", req.getUid());
        ResponseMsgSingle<LoginMethodResult> rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_QUERY_LOGIN_METHOD_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<LoginMethodResult>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;

    }

    @Override
    public ResponseMsgSingle<ChargeDeviceDo> activateDevice(AccountBaseReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("loginId", req.getDid());
        dataMap.put("did", req.getDid());
        dataMap.put("language", req.getLanguage());
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("password", req.getPassword());
        dataMap.put("endUserIp", req.getClientIp());
        dataMap.put("accountType", EAccountType.DEVICE.getCode());
        dataMap.put("region", req.getRegion());
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_ACTIVE_DEVICE_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<ChargeDeviceDo>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<ChargeInfoDo> userChargeQueryActiveState(AccountBaseReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("uid", req.getUid());
        dataMap.put("language", req.getLanguage());
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("did", req.getDid());
        dataMap.put("endUserIp", req.getClientIp());
        dataMap.put("st", req.getSt());
        dataMap.put("region", req.getRegion());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("brand", req.getBrand());
        dataMap.put("model", req.getModel());
        dataMap.put("cpuId", req.getCpuId());

        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_QUERY_ACTIVE_STATE_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<ChargeInfoDo>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountBaseInfoResp> userChargeConfirmActiveState(AccountBaseReq req) {

        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("loginId", req.getDid());
        dataMap.put("language", req.getLanguage());
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("did", req.getDid());
        dataMap.put("endUserIp", req.getClientIp());
        dataMap.put("region", urlEncode(req.getRegion()));
        dataMap.put("sourceId", req.getSourceId());

        ResponseMsgSingle<AccountBaseInfoResp>  rsp = new ResponseMsgSingle<> ();
        try {
            rsp = invoke(host, API_URL_CONFIRM_ACTIVE_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountBaseInfoResp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountBaseInfoResp> queryAccountBaseInfoByLoginId(AccountBaseReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("loginId", req.getLoginId());
        dataMap.put("userType", req.getUserType());
        dataMap.put("actionType", req.getActionType());
        dataMap.put("sourceId", req.getSourceId());

        ResponseMsgSingle<AccountBaseInfoResp> rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_QUERY_ACCOUNT_BASE_INFO_BY_LOGINID_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountBaseInfoResp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<List<SubAccountDo>> getSubAccount(BasicSubAccountReq req) {

        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("subAccountName", req.getSubAccountName());

        ResponseMsgSingle<List<SubAccountDo>> rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_QUERY_SUB_ACCOUNT_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<List<SubAccountDo>>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;

    }

    @Override
    public ResponseStatus delSubAccount(BasicSubAccountReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("subAccountId", req.getSubAccountId());

        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_DEL_SUB_ACCOUNT, timeout, dataMap,
                new TypeReference<ResponseStatus>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private void updateStubInfo(Map<String, Object> stubProperties) {
        host = (String) stubProperties.getOrDefault(EAccountStubProperty.REQ_HOST.name(), this.host);
        timeout = (Integer) stubProperties.getOrDefault(EAccountStubProperty.REQ_TIMEOUT, this.timeout);
    }

    private void updateClientInfo(AccountBaseReq req, Map<String, Object> dataMap) {
        dataMap.put("endUserIp", req.getEndUserIp());
        dataMap.put("endUserRegion", req.getEndUserRegion());
        dataMap.put("clientType", req.getClientType());
        dataMap.put("did", req.getDid());
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("email", urlEncode(req.getEmail()));
    }


    private <T> T invoke(String host, String path, int timeout, Map<String, Object> dataMap,
                         TypeReference<T> typeReference) throws ApiException {
        logger.info("==== start invoke host[{}/{}]", host, path);
        String url = HttpInvokeTools.buildQueryUrl(host, path, dataMap);
        String responseBody = HttpInvokeTools.getInvoke(url, timeout);
        logger.info("==== end invoke host[{}/{}]", host, path);
        return HttpInvokeTools.httpResponse2Object(responseBody, typeReference);
    }

    private <T> T post(String host, String path, int timeout, Map<String, Object> dataMap,
                       TypeReference<T> typeReference) throws ApiException {
        String url = HttpInvokeTools.buildQueryUrl(host, path, dataMap);
        String responseBody = HttpInvokeTools.postInvoke(url, timeout, Maps.newHashMap());
        return HttpInvokeTools.httpResponse2Object(responseBody, typeReference);
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> queryBindUser(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("password", req.getPassword());
        dataMap.put("accountLoginType", req.getAccountLoginType());
        dataMap.put("checkPassword", req.getCheckPassword());

        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_BINDUSER_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountBaseInfoResp> createChannelUser(Map<String, Object> stubProperties, AccountActiveReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("vendorCode", req.getVendorCode());
        dataMap.put("channelId", req.getChannelId());
        dataMap.put("channelDeviceType", urlEncode(req.getChannelDeviceType()));
        dataMap.put("did", req.getDid());
        dataMap.put("cpuId", req.getCpuId());
        dataMap.put("region", req.getRegion());
        dataMap.put("preVendorId", req.getPreVendorId());
        dataMap.put("deviceId", req.getDeviceId());
        dataMap.put("language", req.getLanguage());
        dataMap.put("clientType", req.getClientType());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("sourceId", req.getSourceId());
//        dataMap.put("sourceSystemCode", req.getSourceSystemCode());

        ResponseMsgSingle<AccountBaseInfoResp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = post(host, API_URL_CREATE_CHANNELUSER_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountBaseInfoResp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountBaseInfoResp> queryAccountBaseInfoByAccountId(AccountUserInfoReq accountUserInfoReq) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", String.valueOf(accountUserInfoReq.getAccountId()));
        dataMap.put("rewing", accountUserInfoReq.isRewing());
        dataMap.put("isSearchSubAccount", accountUserInfoReq.isSearchSubAccount());
        dataMap.put("searchChannelVendor", accountUserInfoReq.isSearchChannelVendor());
        if (accountUserInfoReq.isSearchChannelVendor()) {
            dataMap.put("appType", accountUserInfoReq.getAppType());
            dataMap.put("appVer", accountUserInfoReq.getAppVer());
        }
        ResponseMsgSingle<AccountBaseInfoResp> rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_QUERY_ACCOUNT_BASE_INFO_BY_ACCOUNTID_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountBaseInfoResp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountBaseInfoResp> queryAccountBaseInfoByDeviceLogin(DeviceLoginReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();

        dataMap.put("loginId", req.getDid());
        dataMap.put("userType", req.getUserType());
        dataMap.put("actionType", req.getActionType().getCode());
        dataMap.put("isSearchSubAccount", req.isSearchSubAccount());
        dataMap.put("appId", req.getAppId());
        dataMap.put("region", req.getRegion());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("searchChannelVendor", req.isSearchChannelVendor());
        if (req.isSearchChannelVendor()) {
            dataMap.put("appType", req.getAppType());
        }

        ResponseMsgSingle<AccountBaseInfoResp> rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_QUERY_ACCOUNT_BASE_INFO_BY_LOGINID_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountBaseInfoResp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus setBindingTipsFlag(Map<String, Object> stubProperties, Long accountId) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId1", accountId);
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_SET_BINDING_TIPS_FLAG_V1, timeout, dataMap,
                new TypeReference<ResponseStatus>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountBaseInfoResp> queryUserInfoByLoginId(AccountSearchByAccountIdReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("loginId", req.getLoginId());
        dataMap.put("userType", req.getUserType());
        dataMap.put("actionType", req.getActionType());
        dataMap.put("queryUserInfo", true);
        dataMap.put("isSearchSubAccount", req.isSearchSubAccount());
        dataMap.put("searchChannelVendor", req.isSearchChannelVendor());
        dataMap.put("rewing",req.isRewing());
        if (req.isSearchChannelVendor()) {
            dataMap.put("appVer", req.getAppVer());
            dataMap.put("appType", req.getAppType());
        }

        ResponseMsgSingle<AccountBaseInfoResp> rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_QUERY_ACCOUNT_BASE_INFO_BY_LOGINID_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountBaseInfoResp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountBaseInfoResp> queryAccountBaseInfoByAccountIdQR(Long accountId, boolean isRewing, boolean isSearchSubAccount, String appId, long appVer, String region) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", String.valueOf(accountId));
        dataMap.put("rewing", isRewing);
        dataMap.put("isSearchSubAccount", isSearchSubAccount);
        dataMap.put("actionType", EActionType.LOGIN.getCode());
        dataMap.put("appId", appId);
        dataMap.put("appVer", appVer);
        dataMap.put("region", region);
        ResponseMsgSingle<AccountBaseInfoResp> rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_QUERY_ACCOUNT_BASE_INFO_BY_ACCOUNTID_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountBaseInfoResp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<Long> getAccountExpire(String loginId, Integer sourceSystemCode) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("loginId", String.valueOf(loginId));
        dataMap.put("sourceSystemCode", sourceSystemCode);
        ResponseMsgSingle<Long> rsp = new ResponseMsgSingle();
        try {
            rsp = invoke(host, API_URL_GET_ACCOUNT_EXPIRETS, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<Long>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus subscribeEmailBindingV1(Map<String, Object> stubProperties, AccountBaseReq req) {

        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();

//        dataMap.put("endUserIp", req.getEndUserIp());
//        dataMap.put("endUserRegion", req.getEndUserRegion());
//        dataMap.put("clientType", req.getClientType());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("email", urlEncode(req.getEmail()));

        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_CREATE_SUBSCRIBE_EMAIL_BINDING_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<SubscribeEmailBindingRsp>  querySubscribeEmailV1(Map<String, Object> stubProperties, AccountBaseReq req) {

        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();

//        dataMap.put("endUserIp", req.getEndUserIp());
//        dataMap.put("endUserRegion", req.getEndUserRegion());
//        dataMap.put("clientType", req.getClientType());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("accountId1", req.getAccountId1());
//        dataMap.put("email", urlEncode(req.getEmail()));

        ResponseMsgSingle<SubscribeEmailBindingRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_SUBSCRIBE_EMAIL_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<SubscribeEmailBindingRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<ChargeDeviceDo> rechargeDevice(RechargeDeviceReq req) {

        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("did", req.getDid());
        dataMap.put("cardId", req.getCardId());
        dataMap.put("cardPassword", req.getCardPassword());
        dataMap.put("clientIp", req.getClientIp());
        dataMap.put("region", req.getRegion());

        ResponseMsgSingle<ChargeDeviceDo> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_RECHARGE_DEVICE_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<ChargeDeviceDo>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus updateAccountProperty(AccountPropertyReq req) {

        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("property", req.getProperty());
        dataMap.put("updateAppVer", req.isUpdateAppVer());
        dataMap.put("updateClientRegion", req.isUpdateClientRegion());
        if (req.isUpdateAppVer()) {
            dataMap.put("appVer", req.getAppVer());
        }
        if (req.isUpdateClientRegion()) {
            dataMap.put("clientRegion", req.getClientRegion());
        }

        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_UPDATE_ACCOUNT_PROPERTY_V1, timeout, dataMap,
                new TypeReference<ResponseStatus>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgList<LinkAccountResp> queryLinkAccount(AccountBaseReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId1", req.getAccountId1());

        ResponseMsgList<LinkAccountResp> rsp = new ResponseMsgList<>();
        try {
            rsp = invoke(host, API_URL_QUERY_LINK_ACCOUNT_V1, timeout, dataMap,
                new TypeReference<ResponseMsgList<LinkAccountResp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountRegRsp> createDistributorAccount(DistributoAcccountCreateReq req) {

        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("userId", req.getUserId());
        dataMap.put("distributorId", req.getDistributorId());

        ResponseMsgSingle<AccountRegRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = post(host, API_URL_DISTRIBUTOR_ACCOUNT_CREATE_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountRegRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<DistributorAccountInfoRsp> queryDistributorAccount(QueryDistributorAccountReq req) {

        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("userId", req.getUserId());
        dataMap.put("distributorId", req.getDistributorId());

        ResponseMsgSingle<DistributorAccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = post(host, API_URL_DISTRIBUTOR_ACCOUNT_QUERY_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<DistributorAccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    @ExceptionConverter(logException = false)
    @SneakyThrows
    public ResponseStatus saveLoginMethod(SaveLoginMethodReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("areaId", req.getAreaId());
        dataMap.put("loginId", req.getLoginId());
        dataMap.put("loginIdType", req.getLoginIdType());
        dataMap.put("newPassword", req.getNewPassword());
        dataMap.put("verificationCode", req.getVerificationCode());
        dataMap.put("activityId", req.getActivityId());

        return post(host, API_URL_SAVE_LOGIN_METHOD_V1, timeout, dataMap, new TypeReference<ResponseStatus>() {
        });
    }

    @Override
    @ExceptionConverter(logException = false)
    @SneakyThrows
    public ResponseStatus initLoginIdType(InitLoginIdTypeReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", req.getAccountId());

        return post(host, API_URL_INIT_LOGIN_ID_TYPE_V1, timeout, dataMap, new TypeReference<ResponseStatus>() {
        });
    }

    @Override
    @ExceptionConverter(logException = false)
    @SneakyThrows
    public ResponseMsgList<LoginMethodDTO> queryLoginMethods(QueryLoginMethodsReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("loginId", req.getLoginId());
        dataMap.put("loginIdType", req.getLoginIdType());

        return invoke(host, API_URL_QUERY_LOGIN_METHODS_V1, timeout, dataMap,
            new TypeReference<ResponseMsgList<LoginMethodDTO>>() {
        });
    }

    @Override
    @ExceptionConverter(logException = false)
    @SneakyThrows
    public ResponseSingle<CheckForBindRsp> checkForBind(CheckForBindReq req) {
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("loginId", req.getLoginId());
        dataMap.put("loginIdType", req.getLoginIdType());

        return invoke(host, API_URL_CHECK_FOR_BIND_V1, timeout, dataMap,
            new TypeReference<ResponseSingle<CheckForBindRsp>>() {
            });
    }
}
