package com.valor.vod.account.tools;


import com.valor.vod.api.model.user.EAccountProperty;

public class AccountPropertyImmutableTools {
    protected long property = 0;

    public AccountPropertyImmutableTools(long property) {
        this.property = property;
    }

    public static boolean isPropertySet(long props, EAccountProperty property) {
        return (props & property.getValue()) == property.getValue();
    }

    public long getProperty() {
        return property;
    }

    public boolean isPropertySet(EAccountProperty property) {
        return (this.property & property.getValue()) == property.getValue();
    }

    public void setProp(EAccountProperty up) {
        property = property | up.getValue();
    }

    public void setProp(long prop) {
        property = property | prop;
    }

    public void clsProp(long prop) {
        property = (property & (~(prop)));
    }

    public void clsProp(EAccountProperty up) {
        property = (property & (~(up.getValue())));
    }

    public void setBizPlayBase() {
        setProp(EAccountProperty.PLAY_ALLOWED);
    }

    public void clsBizPlayBase() {
        clsProp(EAccountProperty.PLAY_ALLOWED);
    }

    public void setLocationIllegal() {
        if (!isPropertySet(EAccountProperty.LOCATION_UNLIMITED)) {
            setProp(EAccountProperty.LOCATION_ILLEGAL);
        }
    }

    public void clsLocationIllegal() {
        clsProp(EAccountProperty.LOCATION_ILLEGAL);
    }

}
