package com.valor.vod.account.tools;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import common.config.tools.config.ConfigTools3;

public class EncryptTools {

    private static final String USER2_MAC_KEY = ConfigTools3.getString("user2.hash.mac.key", "YBebgiunor86m]uufrey");
    private static final String USER3_MAC_KEY = ConfigTools3.getString("user3.hash.mac.key", "YBebgiunor86m]uufrey");
    private EncryptTools() {
        throw new IllegalStateException("Utility class");
    }

    public static String macHash(String str, String MAC) {
        return Hashing.hmacSha1(MAC.getBytes()).hashString(str, Charsets.UTF_8).toString();
    }

    public static String encryptPassword2(String str) {
        return macHash(str, USER2_MAC_KEY);
    }

    public static String encryptPassword3(String str) {
        return macHash(str, USER3_MAC_KEY);
    }
}
