/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.account.stub;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.valor.vod.common.web.util.TraceUtils;
import common.base.tools.exception.ApiException;
import java.io.IOException;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInvokeTools {
    private static final Logger logger = LoggerFactory.getLogger(HttpInvokeTools.class);

    private HttpInvokeTools() {
        throw new IllegalStateException("Utility class");
    }

    public static String getInvoke(String url, int timeout) throws ApiException {
        try {
            Connection.Response httpResponse = Jsoup.connect((String)url).timeout(timeout).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.GET).header("traceId", TraceUtils.getTraceId()).execute();
            return HttpInvokeTools.getResponseBodyString(httpResponse);
        }
        catch (IOException e) {
            logger.error("Url[{}] Exception:{}", (Object)url, (Object)e);
            throw new ApiException(1003, 10001, e.getMessage());
        }
    }

    public static String postInvoke(String url, int timeout, Map<String, Object> dataMap) throws ApiException {
        try {
            Connection httpConnection = Jsoup.connect((String)url).timeout(timeout).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.POST).header("traceId", TraceUtils.getTraceId());
            httpConnection.header("Content-Type", "application/json;charset=UTF-8");
            httpConnection.requestBody(HttpInvokeTools.toJson(dataMap));
            Connection.Response httpResponse = httpConnection.execute();
            return HttpInvokeTools.getResponseBodyString(httpResponse);
        }
        catch (IOException e) {
            logger.error("Url[{}] Exception:{}", (Object)url, (Object)e);
            throw new ApiException(1003, 10001, e.getMessage());
        }
    }

    public static <T> T httpResponse2Object(String jsonResponse, TypeReference<T> reference) throws ApiException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return (T)objectMapper.readValue(jsonResponse, reference);
        }
        catch (IOException e) {
            logger.error("[USER3 API STUB]. jsonResponse[{}].", (Object)jsonResponse, (Object)e);
            throw new ApiException(1003, 10002, e.getMessage());
        }
    }

    public static String toJson(Object objs) throws ApiException {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(objs);
        }
        catch (IOException e) {
            logger.error("[USER3 API STUB] Exception:{}", (Throwable)e);
            throw new ApiException(1003, 10002, e.getMessage());
        }
    }

    public static String buildQueryUrl(String host, String path, Map<String, Object> dataMap) {
        String queryString = Joiner.on((String)"&").useForNull("").withKeyValueSeparator("=").join(dataMap);
        return host + path + "?" + queryString;
    }

    private static String getResponseBodyString(Connection.Response httpResponse) throws ApiException {
        if (httpResponse.statusCode() == 200 || httpResponse.statusCode() == 555) {
            String jsonResponse = httpResponse.body();
            if (Strings.isNullOrEmpty((String)jsonResponse)) {
                throw new ApiException(1003, 10005, "Http response is empty.");
            }
            return jsonResponse;
        }
        throw new ApiException(1003, 10004, "Http status code:" + httpResponse.statusCode());
    }
}

