package com.valor.vod.api.common;


import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Predicate;

public class ListTool {
    private static final Logger logger = LoggerFactory.getLogger(ListTool.class);

    public static <T> List<T> Page(List<T> ts, int first, int max) {
        List<T> newts = new ArrayList<>();
        if (first < 0) {
            return newts;
        }
        if (max <= 0) {
            return newts;
        }
        if (first >= ts.size()) {
            return newts;
        }
        for (int i = first; i < first + max; i++) {
            if (i >= ts.size()) {
                break;
            }
            newts.add(ts.get(i));
        }
        return newts;
    }


    public static Map<String, String> extra2Map(String extra) {
        if (StringUtils.isEmpty(extra)) {
            return new HashMap<>();
        }

        Map<String, String> map = new HashMap<>();
        String[] items = extra.split("&");
        for (int i = 0; i < items.length; i++) {
            String[] kv = items[i].split("=");
            if (kv.length != 2) {
                continue;
            }
            map.put(kv[0], kv[1]);
        }
        return map;

//        try {
//            return Splitter.on("&")
//                .trimResults()
//                .withKeyValueSeparator("=")
//                .split(extra);
//
//        } catch (Exception e) {
//            logger.error("Invalid playlist extra:{}", e);
//            return Maps.newHashMap();
//        }
    }

    static public boolean isInSets(List<Set<Long>> idSets, long id) {
        for (int i = 0; i < idSets.size(); i++) {
            Set<Long> idSet = idSets.get(i);
            if (idSet.contains(id)) {
                return true;
            }
        }
        return false;
    }

    public static <T> int getCount(List<T> ts) {
        if (ts == null) {
            return 0;
        }
        return ts.size();
    }

    public static <T> Set<T> toHashSet(List<T> ts) {
        Set<T> set = new HashSet<>();
        for (int i = 0; i < ts.size(); i++) {
            set.add(ts.get(i));
        }
        return set;
    }

    public static <T> List<T> toList(T... ts) {
        List<T> list = new ArrayList<>();
        for (int i = 0; i < ts.length; i++) {
            list.add(ts[i]);
        }
        return list;
    }

    public static <T> List<T> toList(Set<T> tSet) {
        List<T> list = new ArrayList<>(tSet);
        return list;
    }

    public static <T> List<T> top(List<T> ts, Predicate<T> toBeTop) {
        List<T> tailTs = new ArrayList<>();
        List<T> topTs = new ArrayList<>();
        for (int i = 0; i < ts.size(); i++) {
            T t = ts.get(i);
            boolean top = toBeTop.test(t);
            if (top) {
                topTs.add(ts.get(i));
            } else {
                tailTs.add(ts.get(i));
            }
        }
        List<T> newTs = new ArrayList<>();
        newTs.addAll(topTs);
        newTs.addAll(tailTs);
        return newTs;
    }

    public static <T> List<T> bottom(List<T> ts, Predicate<T> toBeBottom) {
        List<T> tailTs = new ArrayList<>();
        List<T> topTs = new ArrayList<>();
        for (int i = 0; i < ts.size(); i++) {
            T t = ts.get(i);
            boolean bottom = toBeBottom.test(t);
            if (bottom) {
                tailTs.add(ts.get(i));
            } else {
                topTs.add(ts.get(i));
            }
        }
        List<T> newTs = new ArrayList<>();
        newTs.addAll(topTs);
        newTs.addAll(tailTs);
        return newTs;
    }

    public static List<String> split(String str, String spliter, boolean withSpace) {
        if (StringUtils.isBlank(str)) {
            return new ArrayList<>();
        }
        try {
            if (withSpace) {
                String[] items = str.split(spliter, -1);
                return Arrays.asList(items);
            } else {
                String[] items = str.split(spliter);
                return Arrays.asList(items);
            }

        } catch (Exception e) {
            logger.error("split(),invalid str {}", e);
            return new ArrayList<>();
        }
    }

    public static Set<String> splitAsLinkedHashSet(String str, String spliter, boolean withSpace) {
        Set<String> resultSet = new LinkedHashSet<>();
        if (StringUtils.isBlank(str)) {
            return resultSet;
        }
        try {
            String[] items = new String[0];
            if (withSpace) {
                items = str.split(spliter, -1);
            } else {
                items = str.split(spliter);
            }
            for (int i = 0; i < items.length; i++) {
                resultSet.add(items[i]);
            }
            return resultSet;
        } catch (Exception e) {
            logger.error("split(),invalid str {}", e);
            return resultSet;
        }
    }

    static public String merge(List<String> strs, String spliter) {
        if (CollectionUtils.isEmpty(strs)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.size(); i++) {
            if (i != 0) {
                sb.append(spliter);
            }
            sb.append(strs.get(i));
        }
        return sb.toString();
    }
}
