package com.valor.vod.api.common;

import org.springframework.util.CollectionUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SetTool {

    public static <T> Set<T> asHashSet(T... ts) {
        Set<T> set = new HashSet<>();
        for (int i = 0; i < ts.length; i++) {
            set.add(ts[i]);
        }
        return set;
    }

    public static <T> Set<T> asHashSet(List<T> ts) {
        Set<T> set = new HashSet<>();
        if (CollectionUtils.isEmpty(ts)) {
            return set;
        }
        for (int i = 0; i < ts.size(); i++) {
            set.add(ts.get(i));
        }
        return set;
    }

}
