package com.valor.vod.api.common.client;


import java.io.UnsupportedEncodingException;

/**
 * Created by Frank.Huang on 2016/7/14.
 */
public class ActKey implements IStringSerializable {
    private String did = "";
    private String sha1Pwd = "";

    public static ActKey valueOf(String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Session key:null");
        }

        String[] strArr = value.split("#!");
        if (strArr.length != 2) {
            throw new IllegalArgumentException("Activate key");
        }

        ActKey actKey = new ActKey();

        actKey.did = strArr[0];
        actKey.sha1Pwd = strArr[1];
        return actKey;
    }

    public static ActKey valueOf(byte[] bytes) {
        return valueOf(new String(bytes));
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getSha1Pwd() {
        return sha1Pwd;
    }

    public void setSha1Pwd(String sha1Pwd) {
        this.sha1Pwd = sha1Pwd;
    }

    @Override
    public String toSerializeString() {
        return (did + "#!" + sha1Pwd);
    }

    @Override
    public byte[] toSerializeBytes() {
        try {
            return toSerializeString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}
