package com.valor.vod.api.common.client;

import java.io.UnsupportedEncodingException;

/**
 * Created by Frank.Huang on 2016/7/14.
 */
public class SessionKey implements IStringSerializable {
    private String did = "";
    private String userKey = "";

    public static SessionKey valueOf(String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Session key:null");
        }
        String[] strArr = value.split("#!");
        if (strArr.length != 2) {
            throw new IllegalArgumentException("Session key:" + strArr.length);
        }

        SessionKey sessionKey = new SessionKey();

        sessionKey.did = strArr[0];
        sessionKey.userKey = strArr[1];

        return sessionKey;
    }

    public static SessionKey valueOf(byte[] bytes) {
        return valueOf(new String(bytes));
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getUserKey() {
        return userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    @Override
    public String toSerializeString() {
        return (did + "#!" + userKey);
    }

    @Override
    public byte[] toSerializeBytes() {
        try {
            return toSerializeString().getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }


}
