package com.valor.vod.api.common.encrypt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import static com.valor.vod.api.common.encrypt.ByteHexUtils.byte2hex;

/**
 * Project     : volor
 * Description :
 * Author      : Frank
 * Create Time : 2015/11/29 13:43
 */
public class MD5Checksum {
    private static final Logger logger = LoggerFactory.getLogger(MD5Checksum.class);
    MessageDigest digest;

    public MD5Checksum() {
        try {
            digest = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            logger.error("MessageDigest", e);
        }
    }

    public void update(String str) {
        if (digest != null) {
            digest.update(str.getBytes(), 0, str.getBytes().length);
        }
    }

    public void update(byte[] bytes) {
        if (digest != null) {
            digest.update(bytes, 0, bytes.length);
        }
    }

    public String getChecksum() {
        return byte2hex(digest.digest(), true);
    }
}
