/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.api.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTool {
    private static final Logger logger = LoggerFactory.getLogger(MapTool.class);

    public static <K, V> V getOrNew(Map<K, V> ms, K k, Class<V> clazz) {
        Object v = null;
        if (ms.containsKey(k)) {
            v = ms.get(k);
        } else {
            try {
                v = clazz.newInstance();
                ms.put(k, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v;
    }

    public static <K, V> Set<V> getOrNewHashSet(Map<K, Set<V>> ms, K k) {
        Set<Object> v = null;
        if (ms.containsKey(k)) {
            v = ms.get(k);
        } else {
            v = new HashSet();
            ms.put(k, v);
        }
        return v;
    }

    public static <K, V> Set<V> getOrNewLinkedHashSet(Map<K, Set<V>> ms, K k) {
        Set<Object> v = null;
        if (ms.containsKey(k)) {
            v = ms.get(k);
        } else {
            v = new LinkedHashSet();
            ms.put(k, v);
        }
        return v;
    }

    public static <K, V> List<V> getOrNewArrayList(Map<K, List<V>> ms, K k) {
        List<Object> v = null;
        if (ms.containsKey(k)) {
            v = ms.get(k);
        } else {
            v = new ArrayList();
            ms.put(k, v);
        }
        return v;
    }

    public static <K, VK, VV> Map<VK, VV> getOrNewHashMap(Map<K, Map<VK, VV>> ms, K k) {
        Map<Object, Object> v = null;
        if (ms.containsKey(k)) {
            v = ms.get(k);
        } else {
            v = new HashMap();
            ms.put(k, v);
        }
        return v;
    }

    public static <K, VK, VV> Map<VK, VV> getOrNewLinkedHashMap(Map<K, Map<VK, VV>> ms, K k) {
        Map<Object, Object> v = null;
        if (ms.containsKey(k)) {
            v = ms.get(k);
        } else {
            v = new LinkedHashMap();
            ms.put(k, v);
        }
        return v;
    }

    public static <K, V> int getCount(Map<K, V> ms) {
        if (ms == null) {
            return 0;
        }
        return ms.size();
    }

    public static <K, V> V get(Map<K, V> map, K k) {
        if (!map.containsKey(k)) {
            return null;
        }
        return map.get(k);
    }
}

