package com.valor.vod.api.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;

/** Created by Frank.Huang on 2016/7/9. */
public class BytesUtils {
    private static final Logger logger = LoggerFactory.getLogger(BytesUtils.class);

    public static <T> byte[] object2Bytes(T object) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutput out = new ObjectOutputStream(bos)) {
            out.writeObject(object);
            return bos.toByteArray();
        } catch (Exception e) {
            logger.error("{}", e);
            return new byte[0];
        }
    }

    public static <T> T bytes2Object(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInput in = new ObjectInputStream(bis)) {
            return (T) in.readObject();
        } catch (Exception e) {
            logger.error("{}", e);
            return null;
        }
    }
}
