package com.valor.vod.api.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DateTime {
    private static ThreadLocal<SimpleDateFormat> dateTimeThreadLocal =
            new ThreadLocal<SimpleDateFormat>() {
                @Override
                protected SimpleDateFormat initialValue() {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                }
            };
    private static ThreadLocal<SimpleDateFormat> dateTimeMsThreadLocal =
            new ThreadLocal<SimpleDateFormat>() {
                @Override
                protected SimpleDateFormat initialValue() {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                }
            };

    // 不是单例，代价极高
    private static ThreadLocal<Calendar> calendar =
            new ThreadLocal<Calendar>() {
                @Override
                protected Calendar initialValue() {
                    return Calendar.getInstance();
                }
            };

    public static DateTime Max = null;
    public static DateTime Min = null;
    public static Date MaxDate = null;
    public static Date MinDate = null;

    Date dateTime = new Date();

    static {
        Min = parse("1970-01-01 08:00:00");
        Max = parse("9999-01-01 08:00:00");
        MinDate = Min.toDate();
        MaxDate = Max.toDate();
    }

    public DateTime() {}

    public DateTime(Date dateTime) {
        if (dateTime == null) {
            dateTime = new Date();
        }
        this.dateTime = dateTime;
    }

    public DateTime(long milliseconds) {
        calendar.get().setTimeInMillis(milliseconds);
        this.dateTime = calendar.get().getTime();
    }

    public static DateTime parse(String date) {
        if (date == null) {
            return null;
        }
        // yyyy-MM-dd HH:mm:ss.SSS
        if (date.length() == 23) {
            try {
                Date d = dateTimeMsThreadLocal.get().parse(date);
                return new DateTime(d);

            } catch (ParseException e) {
                return null;
            }
        }
        // yyyy-MM-dd HH:mm:ss.S
        else if (date.length() == 21 || date.length() == 22) {
            try {
                Date d = dateTimeMsThreadLocal.get().parse(date);
                return new DateTime(d);

            } catch (ParseException e) {
                return null;
            }
        }
        // yyyy-MM-dd HH:mm:ss
        else if (date.length() == 19) {
            try {
                Date d = dateTimeThreadLocal.get().parse(date);
                return new DateTime(d);

            } catch (ParseException e) {
                return null;
            }
        }
        // yyyy-MM-dd
        else if (date.length() == 10) {
            try {
                Date d = dateTimeThreadLocal.get().parse(date + " 00:00:00");
                return new DateTime(d);

            } catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static DateTime parse(String date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Date d = dateFormat.parse(date);
            return new DateTime(d);

        } catch (ParseException e) {
            return null;
        }
    }

    public static DateTime getNow() {
        return new DateTime();
    }

    public Date toDate() {
        return dateTime;
    }

    public int getYear() {
        calendar.get().setTime(dateTime);
        return calendar.get().get(Calendar.YEAR);
    }

    public DateTime setYear(int year) {
        calendar.get().setTime(dateTime);
        calendar.get().set(Calendar.YEAR, year);
        return new DateTime(calendar.get().getTime());
    }

    public int getMonth() {
        calendar.get().setTime(dateTime);
        return calendar.get().get(Calendar.MONTH) + 1;
    }

    public DateTime setMonth(int month) {
        calendar.get().setTime(dateTime);
        calendar.get().set(Calendar.MONTH, month - 1);
        return new DateTime(calendar.get().getTime());
    }

    public int getDay() {
        calendar.get().setTime(dateTime);
        return calendar.get().get(Calendar.DAY_OF_MONTH);
    }

    public DateTime setDay(int day) {
        calendar.get().setTime(dateTime);
        calendar.get().set(Calendar.DAY_OF_MONTH, day);
        return new DateTime(calendar.get().getTime());
    }

    public int getHour() {
        calendar.get().setTime(dateTime);
        return calendar.get().get(Calendar.HOUR);
    }

    public DateTime setHour(int hour) {
        calendar.get().setTime(dateTime);
        calendar.get().set(Calendar.HOUR, hour);
        return new DateTime(calendar.get().getTime());
    }

    public int getMinute() {
        calendar.get().setTime(dateTime);
        return calendar.get().get(Calendar.MINUTE);
    }

    public DateTime setMinute(int minute) {
        calendar.get().setTime(dateTime);
        calendar.get().set(Calendar.MINUTE, minute);
        return new DateTime(calendar.get().getTime());
    }

    public int getSecond() {
        calendar.get().setTime(dateTime);
        return calendar.get().get(Calendar.SECOND);
    }

    public DateTime setSecond(int second) {
        calendar.get().setTime(dateTime);
        calendar.get().set(Calendar.SECOND, second);
        return new DateTime(calendar.get().getTime());
    }

    public int getMillisecond() {
        calendar.get().setTime(dateTime);
        return calendar.get().get(Calendar.MILLISECOND);
    }

    public DateTime setMillisecond(int millisecond) {
        calendar.get().setTime(dateTime);
        calendar.get().set(Calendar.MILLISECOND, millisecond);
        return new DateTime(calendar.get().getTime());
    }

    public int getDayOfWeek() {
        calendar.get().setTime(dateTime);
        return calendar.get().get(Calendar.DAY_OF_WEEK);
    }

    public int getDayOfYear() {
        calendar.get().setTime(dateTime);
        return calendar.get().get(Calendar.DAY_OF_YEAR);
    }

    public long getTotalMilliseconds() {
        calendar.get().setTime(dateTime);
        return calendar.get().getTimeInMillis();
    }

    public DateTime addYears(int years) {
        calendar.get().setTime(dateTime);
        calendar.get().add(Calendar.YEAR, years);
        return new DateTime(calendar.get().getTime());
    }

    public DateTime addMonths(int months) {
        calendar.get().setTime(dateTime);
        calendar.get().add(Calendar.MONTH, months);
        return new DateTime(calendar.get().getTime());
    }

    public DateTime addDays(int days) {
        calendar.get().setTime(dateTime);
        calendar.get().add(Calendar.DAY_OF_YEAR, days);
        return new DateTime(calendar.get().getTime());
    }

    public DateTime addHours(int hours) {
        calendar.get().setTime(dateTime);
        calendar.get().add(Calendar.HOUR, hours);
        return new DateTime(calendar.get().getTime());
    }

    public DateTime addMinutes(int minutes) {
        calendar.get().setTime(dateTime);
        calendar.get().add(Calendar.MINUTE, minutes);
        return new DateTime(calendar.get().getTime());
    }

    public DateTime addSeconds(int seconds) {
        calendar.get().setTime(dateTime);
        calendar.get().add(Calendar.SECOND, seconds);
        return new DateTime(calendar.get().getTime());
    }

    public DateTime addMilliseconds(int milliseconds) {
        calendar.get().setTime(dateTime);
        calendar.get().add(Calendar.MILLISECOND, milliseconds);
        return new DateTime(calendar.get().getTime());
    }

    public int compareTo(DateTime date) {
        Date d1 = this.dateTime;
        Date d2 = date.dateTime;
        return d1.compareTo(d2);
    }

    public boolean before(DateTime date) {
        Date d1 = this.dateTime;
        Date d2 = date.dateTime;
        return d1.before(d2);
    }

    public boolean after(DateTime date) {
        Date d1 = this.dateTime;
        Date d2 = date.dateTime;
        return d1.after(d2);
    }

    public boolean equals(DateTime date) {
        Date d1 = this.dateTime;
        Date d2 = date.dateTime;
        return d1.equals(d2);
    }

    public DateTime clone() {
        calendar.get().setTime(dateTime);
        return new DateTime(calendar.get().getTime());
    }

    public static DateTime max(DateTime... dateTimes) {
        if (dateTimes.length == 0) {
            return null;
        }

        DateTime max = dateTimes[0];
        for (int i = 0; i < dateTimes.length; i++) {
            if (max.before(dateTimes[i])) {
                max = dateTimes[i];
            }
        }
        return max;
    }

    public static DateTime min(DateTime... dateTimes) {
        if (dateTimes.length == 0) {
            return null;
        }

        DateTime min = dateTimes[0];
        for (int i = 0; i < dateTimes.length; i++) {
            if (min.after(dateTimes[i])) {
                min = dateTimes[i];
            }
        }
        return min;
    }

    public String toString(String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        String str = f.format(dateTime);
        return str;
    }

    @Override
    public String toString() {
        String str = dateTimeThreadLocal.get().format(dateTime);
        return str;
    }

    // ==========Date============
    public static Date addYears(Date date, int years) {
        calendar.get().setTime(date);
        calendar.get().add(Calendar.YEAR, years);
        return calendar.get().getTime();
    }

    public static Date addMonths(Date date, int months) {
        calendar.get().setTime(date);
        calendar.get().add(Calendar.MONTH, months);
        return calendar.get().getTime();
    }

    public static Date addDays(Date date, int days) {
        calendar.get().setTime(date);
        calendar.get().add(Calendar.DAY_OF_YEAR, days);
        return calendar.get().getTime();
    }

    public static Date addHours(Date date, int hours) {
        calendar.get().setTime(date);
        calendar.get().add(Calendar.HOUR, hours);
        return calendar.get().getTime();
    }

    public static Date addMinutes(Date date, int minutes) {
        calendar.get().setTime(date);
        calendar.get().add(Calendar.MINUTE, minutes);
        return calendar.get().getTime();
    }

    public static Date addSeconds(Date date, int seconds) {
        calendar.get().setTime(date);
        calendar.get().add(Calendar.SECOND, seconds);
        return calendar.get().getTime();
    }

    public static Date addMilliseconds(Date date, int milliseconds) {
        calendar.get().setTime(date);
        calendar.get().add(Calendar.MILLISECOND, milliseconds);
        return calendar.get().getTime();
    }

    public static String toString(Date date) {
        if (date == null) {
            return "";
        }
        String str = dateTimeThreadLocal.get().format(date);
        return str;
    }

    public static String toString(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat f = new SimpleDateFormat(format);
        String str = f.format(date);
        return str;
    }

    public static Date toDate(long milliseconds) {
        calendar.get().setTimeInMillis(milliseconds);
        return calendar.get().getTime();
    }

    // ********************test********************
    private static void assertValue(String name, DateTime date, String value) throws Exception {
        if (value == null) {
            if (date != null) {
                throw new Exception(name);
            }
        } else {
            String str = date.toString("yyyy-MM-dd HH:mm:ss.SSS");
            if (!str.equals(value)) {
                throw new Exception(name);
            }
        }
    }

    private static void assertValue(String name, Date date, String value) throws Exception {
        if (value == null) {
            if (date != null) {
                throw new Exception(name);
            }
        } else {
            String str = new DateTime(date).toString("yyyy-MM-dd HH:mm:ss.SSS");
            if (!str.equals(value)) {
                throw new Exception(name);
            }
        }
    }

    private static void assertValue(String name, int value1, int value2) throws Exception {
        if (value1 != value2) {
            throw new Exception(name);
        }
    }

    private static void assertValue(String name, long value1, long value2) throws Exception {
        if (value1 != value2) {
            throw new Exception(name);
        }
    }

    private static void assertValue(String name, boolean value) throws Exception {
        if (!value) {
            throw new Exception(name);
        }
    }

    public static void test() {
        ExecutorService taskExecutor = Executors.newFixedThreadPool(500);
        List<Callable<Boolean>> callables = new ArrayList<>();
        for (int i = 0; i < 100; i++) {
            Callable<Boolean> callable =
                    new Callable() {
                        @Override
                        public Boolean call() {
                            try {
                                DateTime date1 = DateTime.parse("2019-01-01 13:02:00");
                                assertValue("1", date1, "2019-01-01 13:02:00.000");
                                DateTime date2 = DateTime.parse("2019-01-01");
                                assertValue("2", date2, "2019-01-01 00:00:00.000");
                                DateTime date3 = DateTime.parse("2019-01-01 01:33:21.335");
                                assertValue("3", date3, "2019-01-01 01:33:21.335");
                                DateTime date4 = DateTime.parse("xxx");
                                assertValue("4", date4, null);
                                DateTime date5 = new DateTime(1575459951000L);
                                assertValue("5", date5, "2019-12-04 19:45:51.000");
                                DateTime date6 =
                                        DateTime.parse(
                                                "2019/02/01 01:33:21", "yyyy/MM/dd HH:mm:ss");
                                assertValue("6", date6, "2019-02-01 01:33:21.000");
                                DateTime date = DateTime.parse("2019-02-03 09:36:15.786");
                                assertValue("7", date.getYear(), 2019);
                                assertValue("8", date.getMonth(), 2);
                                assertValue("9", date.getDay(), 3);
                                assertValue("10", date.getHour(), 9);
                                assertValue("11", date.getMinute(), 36);
                                assertValue("12", date.getSecond(), 15);
                                assertValue("13", date.getMillisecond(), 786);
                                assertValue("14", date.getTotalMilliseconds(), 1549157775786L);
                                date = date.setYear(2018);
                                assertValue("15", date, "2018-02-03 09:36:15.786");
                                date = date.setMonth(3);
                                assertValue("16", date, "2018-03-03 09:36:15.786");
                                date = date.setDay(19);
                                assertValue("17", date, "2018-03-19 09:36:15.786");
                                date = date.setHour(12);
                                assertValue("18", date, "2018-03-19 12:36:15.786");
                                date = date.setMinute(58);
                                assertValue("19", date, "2018-03-19 12:58:15.786");
                                date = date.setSecond(35);
                                assertValue("20", date, "2018-03-19 12:58:35.786");
                                date = date.setMillisecond(362);
                                assertValue("21", date, "2018-03-19 12:58:35.362");
                                assertValue("22", date.getDayOfWeek(), 2);
                                assertValue("23", date.getDayOfYear(), 78);
                                date = date.addYears(3);
                                assertValue("24", date, "2021-03-19 12:58:35.362");
                                date = date.addMonths(2);
                                assertValue("25", date, "2021-05-19 12:58:35.362");
                                date = date.addDays(5);
                                assertValue("26", date, "2021-05-24 12:58:35.362");
                                date = date.addHours(6);
                                assertValue("27", date, "2021-05-24 18:58:35.362");
                                date = date.addMinutes(10);
                                assertValue("28", date, "2021-05-24 19:08:35.362");
                                date = date.addSeconds(20);
                                assertValue("29", date, "2021-05-24 19:08:55.362");
                                date = date.addMilliseconds(15);
                                assertValue("30", date, "2021-05-24 19:08:55.377");
                                assertValue("31", date1.compareTo(date2), 1);
                                DateTime date7 = DateTime.parse("2019-01-01 13:02:00");
                                assertValue("32", date1.compareTo(date7), 0);
                                assertValue("33", date2.compareTo(date3), -1);
                                assertValue("34", date2.before(date3));
                                assertValue("35", date1.after(date2));
                                assertValue("36", date1.equals(date7));
                                DateTime date8 = date1.clone();
                                assertValue("37", date8, "2019-01-01 13:02:00.000");
                                DateTime maxDate = DateTime.max(date1, date2, date3, date5, date6);
                                assertValue("38", maxDate, "2019-12-04 19:45:51.000");
                                DateTime minDate = DateTime.min(date1, date2, date3, date5, date6);
                                assertValue("39", minDate, "2019-01-01 00:00:00.000");

                                // ---------static----------
                                Date d = DateTime.parse("2019-02-03 09:36:15.786").toDate();
                                Date d1 = DateTime.addYears(d, 2);
                                assertValue("40", d1, "2021-02-03 09:36:15.786");
                                Date d2 = DateTime.addMonths(d, 3);
                                assertValue("41", d2, "2019-05-03 09:36:15.786");
                                Date d3 = DateTime.addDays(d, 10);
                                assertValue("42", d3, "2019-02-13 09:36:15.786");
                                Date d4 = DateTime.addHours(d, 5);
                                assertValue("43", d4, "2019-02-03 14:36:15.786");
                                Date d5 = DateTime.addMinutes(d, 11);
                                assertValue("44", d5, "2019-02-03 09:47:15.786");
                                Date d6 = DateTime.addSeconds(d, 12);
                                assertValue("45", d6, "2019-02-03 09:36:27.786");
                                Date d7 = DateTime.addMilliseconds(d, 101);
                                assertValue("46", d7, "2019-02-03 09:36:15.887");

                            } catch (Exception e) {
                                System.out.println("test exception:" + e.getMessage());
                            }
                            return true;
                        }
                    };
            callables.add(callable);
        }
        try {
            taskExecutor.invokeAll(callables);
            System.out.println("test complete success");
        } catch (InterruptedException e) {
            System.out.println("test exception:wait tasks error");
        }
    }
}
