package com.valor.vod.api.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SqlTools {
    public static int getPageCount(long recordCount, int pageSize) {
        int pageCount = 0;
        if (recordCount != 0) {
            pageCount = (int) (recordCount / pageSize);
            if (recordCount % pageSize != 0) {
                pageCount++;
            }
        }
        return pageCount;
    }

    public static <T> List<List<T>> splitBatch(List<T> ts, int batchSize) {
        List<List<T>> tss = new ArrayList<>();
        if (ts.size() <= batchSize || ts.size() == 0) {
            tss.add(ts);
            return tss;
        }
        List<T> items = null;
        for (int i = 0; i < ts.size(); i++) {
            if (i % batchSize == 0) {
                items = new ArrayList<>();
                tss.add(items);
            }
            items.add(ts.get(i));
        }
        return tss;
    }

    public static Long parseLong(Object o, Long defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(o.toString());
        } catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Integer parseInt(Object o, Integer defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(o.toString());
        } catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Date parseDate(Object o, Date defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        try {
            DateTime dt = DateTime.parse(o.toString());
            if (dt == null) {
                return defaultValue;
            }
            return dt.toDate();
        } catch (Exception ex) {
            return defaultValue;
        }
    }

    public static String parseString(Object o, String defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        try {
            return o.toString();
        } catch (Exception ex) {
            return defaultValue;
        }
    }
}
