package com.valor.vod.api.common.client;

import com.valor.vod.api.common.encrypt.AESUtils;
import com.valor.vod.api.common.encrypt.RSAUtils;

/** Created by Frank.Huang on 2016/7/11. */
public class AccessKeyTools {

    public static byte[] getActKey(ActKey actKey, byte[] appkey) throws Exception {
        return getAccessKey(actKey, appkey);
    }

    public static byte[] getSessionKey(SessionKey sessionKey, byte[] appkey) throws Exception {
        return getAccessKey(sessionKey, appkey);
    }

    public static byte[] getAccessKey(IStringSerializable dataObject, byte[] appkey)
            throws Exception {
        return RSAUtils.encryptByPublicKey(dataObject.toSerializeString().getBytes(), appkey);
    }

    public static boolean verify(byte[] data, byte[] clientKey, byte[] sign) throws Exception {
        return RSAUtils.verify(data, clientKey, sign);
    }

    public static String getAppkey(byte[] data, byte[] key) throws Exception {
        return AESUtils.decrypt(data, key);
    }
}
