/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.api.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTool {
    private static final Logger logger = LoggerFactory.getLogger(ListTool.class);

    public static <T> List<T> Page(List<T> ts, int first, int max) {
        ArrayList<T> newts = new ArrayList<T>();
        if (first < 0) {
            return newts;
        }
        if (max <= 0) {
            return newts;
        }
        if (first >= ts.size()) {
            return newts;
        }
        for (int i = first; i < first + max && i < ts.size(); ++i) {
            newts.add(ts.get(i));
        }
        return newts;
    }

    public static Map<String, String> extra2Map(String extra) {
        if (StringUtils.isEmpty((CharSequence)extra)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] items = extra.split("&");
        for (int i = 0; i < items.length; ++i) {
            String[] kv = items[i].split("=");
            if (kv.length != 2) continue;
            map.put(kv[0], kv[1]);
        }
        return map;
    }

    public static boolean isInSets(List<Set<Long>> idSets, long id) {
        for (int i = 0; i < idSets.size(); ++i) {
            Set<Long> idSet = idSets.get(i);
            if (!idSet.contains(id)) continue;
            return true;
        }
        return false;
    }

    public static <T> int getCount(List<T> ts) {
        if (ts == null) {
            return 0;
        }
        return ts.size();
    }

    public static <T> Set<T> toHashSet(List<T> ts) {
        HashSet<T> set = new HashSet<T>();
        for (int i = 0; i < ts.size(); ++i) {
            set.add(ts.get(i));
        }
        return set;
    }

    public static <T> List<T> toList(T ... ts) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < ts.length; ++i) {
            list.add(ts[i]);
        }
        return list;
    }

    public static <T> List<T> toList(Set<T> tSet) {
        ArrayList<T> list = new ArrayList<T>(tSet);
        return list;
    }

    public static <T> List<T> top(List<T> ts, Predicate<T> toBeTop) {
        ArrayList<T> tailTs = new ArrayList<T>();
        ArrayList<T> topTs = new ArrayList<T>();
        for (int i = 0; i < ts.size(); ++i) {
            T t = ts.get(i);
            boolean top = toBeTop.test(t);
            if (top) {
                topTs.add(ts.get(i));
                continue;
            }
            tailTs.add(ts.get(i));
        }
        ArrayList<T> newTs = new ArrayList<T>();
        newTs.addAll(topTs);
        newTs.addAll(tailTs);
        return newTs;
    }

    public static <T> List<T> bottom(List<T> ts, Predicate<T> toBeBottom) {
        ArrayList<T> tailTs = new ArrayList<T>();
        ArrayList<T> topTs = new ArrayList<T>();
        for (int i = 0; i < ts.size(); ++i) {
            T t = ts.get(i);
            boolean bottom = toBeBottom.test(t);
            if (bottom) {
                tailTs.add(ts.get(i));
                continue;
            }
            topTs.add(ts.get(i));
        }
        ArrayList<T> newTs = new ArrayList<T>();
        newTs.addAll(topTs);
        newTs.addAll(tailTs);
        return newTs;
    }

    public static List<String> split(String str, String spliter, boolean withSpace) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ArrayList<String>();
        }
        try {
            if (withSpace) {
                String[] items = str.split(spliter, -1);
                return Arrays.asList(items);
            }
            String[] items = str.split(spliter);
            return Arrays.asList(items);
        }
        catch (Exception e) {
            logger.error("split(),invalid str {}", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public static Set<String> splitAsLinkedHashSet(String str, String spliter, boolean withSpace) {
        LinkedHashSet<String> resultSet = new LinkedHashSet<String>();
        if (StringUtils.isBlank((CharSequence)str)) {
            return resultSet;
        }
        try {
            String[] items = new String[]{};
            items = withSpace ? str.split(spliter, -1) : str.split(spliter);
            for (int i = 0; i < items.length; ++i) {
                resultSet.add(items[i]);
            }
            return resultSet;
        }
        catch (Exception e) {
            logger.error("split(),invalid str {}", (Throwable)e);
            return resultSet;
        }
    }

    public static String merge(List<String> strs, String spliter) {
        if (strs == null || strs.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.size(); ++i) {
            if (i != 0) {
                sb.append(spliter);
            }
            sb.append(strs.get(i));
        }
        return sb.toString();
    }
}

