/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.api.common.client;

import com.valor.vod.api.common.client.IStringSerializable;
import java.io.UnsupportedEncodingException;

public class SessionKey
implements IStringSerializable {
    private String did = "";
    private String userKey = "";

    public static SessionKey valueOf(String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Session key:null");
        }
        String[] strArr = value.split("#!");
        if (strArr.length != 2) {
            throw new IllegalArgumentException("Session key:" + strArr.length);
        }
        SessionKey sessionKey = new SessionKey();
        sessionKey.did = strArr[0];
        sessionKey.userKey = strArr[1];
        return sessionKey;
    }

    public static SessionKey valueOf(byte[] bytes) {
        return SessionKey.valueOf(new String(bytes));
    }

    public String getDid() {
        return this.did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    @Override
    public String toSerializeString() {
        return this.did + "#!" + this.userKey;
    }

    @Override
    public byte[] toSerializeBytes() {
        try {
            return this.toSerializeString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

