package com.valor.vod.api.model.cloud;

import lombok.Data;

@Data
public class MySharePkgDo {
    /**
     * 排序
     */
    private Integer number;
    /**
     * 类型：网盘包/网盘
     */
    private int type;
    /**
     * id 分享记录的id
     */
    private String id;
    /**
     * id 网盘包/网盘
     */
    private String entityId;
    /**
     * 名字
     */
    private String cloudName;
    /**
     * 描述
     */
    private String description;

    /**
     * 提取密码，仅在分享链接时设置后显示
     */
    private String protectionPassword;

    /**
     * 导入有效期限制，仅在分享链接时设置后显示
     */
    private String expirationDate;

    /**
     * 网盘包有效期，单位m,d
     */
    private String servicePeriod;

    /**
     * 用户白名单，仅在分享链接时设置后显示
     */
    private String authorizationList;

    /**
     * 被分享的账号类型
     */
    private int accountType;

    /**
     * 被分享的用户账号
     */
    private String user;

    /**
     * 分享状态
     */
    private int status;

    /**
     * 下载链接
     */
    private String link;
}
