package com.valor.vod.api.model.common.response;

import com.valor.vod.api.model.constant.response.HttpCode2;

/**
 * Project     : volor
 * Description :
 * Author      : Frank
 * Create Time : 2015/10/5 14:01
 */
public class ResponseMsgComm extends ResponseStatus {

    protected int totalCount = 0;
    protected int pageNo = 1;
    protected int pageId = 0;
    protected int pageSize = 0;
    protected int count = 0;

    protected long queryDuration = 0L;
    protected long queryTime = System.currentTimeMillis();

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getQueryDuration() {
        return queryDuration;
    }

    public void setQueryDuration(long queryDuration) {
        this.queryDuration = queryDuration;
    }

    public int getPageId() {
        return pageId;
    }

    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public void setStatus(int retcode, int errcode, String msg) {
        this.retCode = retcode;
        this.errCode = errcode;
        this.message = msg;
    }

    public long getQueryTime() {
        return queryTime;
    }

    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    public void setVersionUnsupported() {
        setStatus(HttpCode2.RET_UNSUPPORTED_VERSION, HttpCode2.ERR_UNSUPPORTED_VERSION, HttpCode2.MSG_UNSUPPORTED_VERSION);
        ///////
    }

    public void setVersionUnsupported(String language) {
        String msgUnsupportedVerson = HttpCode2.MSG_UNSUPPORTED_VERSION;
        if ("pt".equalsIgnoreCase(language)) {
            msgUnsupportedVerson = HttpCode2.MSG_UNSUPPORTED_VERSION_PT;
        } else if ("es".equalsIgnoreCase(language)) {
            msgUnsupportedVerson = HttpCode2.MSG_UNSUPPORTED_VERSION_ES;
        }
        setStatus(HttpCode2.RET_UNSUPPORTED_VERSION, HttpCode2.ERR_UNSUPPORTED_VERSION, msgUnsupportedVerson);
    }
}
