package com.valor.vod.api.model.constant;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Project     : volor
 * Description :
 *
 * @author : Frank
 * Create Time : 2016/1/8 11:24
 */
public enum EPlaylistShowType {
    /**
     * 普通
     */
    NORMAL,

    /**
     * 专题
     */
    SPECIAL_TOPIC,

    FILTER,

    RECOMMEND;

    private static final Map<String, EPlaylistShowType> VALUE_MAP = Stream.of(values())
        .collect(Collectors.toMap(EPlaylistShowType::name, Function.identity()));

    public static EPlaylistShowType of(String value) {
        if (value == null) {
            return null;
        }

        return VALUE_MAP.get(value);
    }
}
