package com.valor.vod.api.model.constant;

/**
 * File        : valormotorserver:${FILE_NAME}
 * Description :
 * Author      : Frank
 * Created     : 2015/8/31
 */
public enum EVideoType {
    /**
     * UNKNOWN, 0
     */
    UNKNOWN,  //=0

    /**
     * PLAYLIST 类型 1
     */
    PLAYLIST,  //=1

    /**
     * 搜索列表 2
     */
    SEARCH_LIST, //=2

    /**
     * This is a movie 3
     */
    MOVIE,//=3
    /**
     * This is a TV Series
     */
    SERIES, //=4
    /**
     * This is a season of a TV series
     */
    SEASON,//=5
    /**
     * This is an episode of a TV season
     */
    EPISODE,//=6

    /**
     * 记录片
     */
    DOCUMENTARY,//=7
    /**
     * 短片
     */
    SHORT,//=8
    /**
     * 视频
     */
    VIDEO,//=9
    /**
     * TV 特别节目
     */
    TV_SPECIAL,//=10


    PERSON,     //11

    ADULT,      //12

    VIDOE_TYPE_END;

    public static EVideoType valueOf(int videoTypeInt) {
        switch (videoTypeInt) {
            case 1:
                return PLAYLIST;
            case 2:
                return SEARCH_LIST;
            case 3:
                return MOVIE;
            case 4:
                return SERIES;
            case 5:
                return SEASON;
            case 6:
                return EPISODE;
            case 7:
                return DOCUMENTARY;
            case 8:
                return SHORT;
            case 9:
                return VIDEO;
            case 10:
                return TV_SPECIAL;
            default:
                return UNKNOWN;
        }
    }
}
