/*
 *      Copyright (c) 2004-2015 YAMJ Members
 *      https://github.com/organizations/YAMJ/teams
 *
 *      This file is part of the Yet Another Media Jukebox (YAMJ).
 *
 *      YAMJ is free software: you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, either version 3 of the License, or
 *      any later version.
 *
 *      YAMJ is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with YAMJ.  If not, see <http://www.gnu.org/licenses/>.
 *
 *      Web: https://github.com/YAMJ/yamj-v3
 *
 */
package com.valor.vod.api.model.constant;

/**
 * List of known job types for people
 */
public enum JobType {

    /**
     * The job type is not known
     */
    UNKNOWN,
    /**
     * The person is a director
     */
    DIRECTOR,
    /**
     * The person is an actor
     */
    ACTOR,

    SOUNDTRACK,
    SELF,
    WRITER,
    /**
     * The person is a producer
     */
    PRODUCER,
    ACTRESS;


    /**
     * Determine the job type from a string
     *
     * @param type
     * @return
     */
    public static JobType fromString(String type) {
        try {
            return valueOf(type.trim().toUpperCase());
        } catch (IllegalArgumentException ex) {
            return UNKNOWN;
        }
    }


    public static JobType valueOf(int jobType) {
        switch (jobType) {
            case 1:
                return DIRECTOR;
            case 2:
                return ACTOR;
            case 3:
                return SOUNDTRACK;
            case 4:
                return SELF;
            case 5:
                return WRITER;
            case 6:
                return PRODUCER;
            case 7:
                return ACTRESS;
            default:
                return UNKNOWN;
        }
    }
}
