package com.valor.vod.api.model.meta.person.v1;

import com.valor.vod.api.model.common.AbstractPrintable;
import com.valor.vod.api.model.constant.JobType;

/**
 * File        : valormotorserver:${FILENAME}
 * Description :
 * Author      : Frank
 * Created     : 2015/9/3
 */
public class PersonBaseDO extends AbstractPrintable {
    private Long personId;
    private String vpid;
    private String name;
    private JobType jobType;

    private String photo;
    private Integer detailInfoExists = 1; // 0: not exists, 1: exists
    private int starMeter;

    public PersonBaseDO() {
    }

    public PersonBaseDO(Long personId, String name, JobType jobType) {
        this.personId = personId;
        this.name = name;
        this.jobType = jobType;
    }

    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobType getJobType() {
        return jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setjobTypeInt(int jobType) {
        this.jobType = JobType.valueOf(jobType);
    }

    public String getVpid() {
        return vpid;
    }

    public void setVpid(String vpid) {
        this.vpid = vpid;
    }

    public String getPhoto() {
        return photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public Integer getDetailInfoExists() {
        return detailInfoExists;
    }

    public void setDetailInfoExists(Integer detailInfoExists) {
        this.detailInfoExists = detailInfoExists;
    }

    public int getStarMeter() {
        return starMeter;
    }

    public void setStarMeter(int starMeter) {
        this.starMeter = starMeter;
    }
}
