/*
 * Created by Gabriel Souza on 03/09/18 18:14
 * Copyright Valoroso Ltd. (c) 2018.  All rights reserved.
 */

package com.valor.vod.api.model.user;
/**
 * 账号登录类型枚举
 *
 * @author Tom
 * @since 2022-10-08
 */
public enum EAccountLoginType {
    /** 设备 */
    DEVICE(0),
    /** 邮箱 */
    EMAIL(1),
    /** 账号卡 */
    ACCOUNT_CARD(2),
    /** 手机 */
    MOBILE(3),
    /** 绑定邮箱 */
    AC_BINDING_EMAIL(4),
    /** 绑定手机 */
    AC_BINDING_MOBILE(5),
    /** 三方 */
    THIRD_PARTY(6);

    int code;

    EAccountLoginType(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public EAccountLoginType getByCode(int code) {
        EAccountLoginType[] loginTypes = EAccountLoginType.values();
        for (int i = 0; i < loginTypes.length; i++) {
            if (loginTypes[i].getCode() == code) {
                return loginTypes[i];
            }
        }
        return null;
    }
}
