package com.valor.vod.api.model.user;

import java.util.Objects;

/**
 * @author Allen.liu
 * @since 2022-11-16
 */
public enum EAccountType {
    /** 设备账户 */
    DEVICE(0),
    /** 正常账户 */
    ACCOUNT(1),
    ;

    int code;

    EAccountType(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static EAccountType of(Integer code) {
        for (EAccountType e : EAccountType.values()) {
            if (Objects.equals(code, e.getCode())) {
                return e;
            }
        }
        return null;
    }
}
