package com.valor.vod.api.model.user;

import java.util.Objects;
import java.util.stream.Stream;

public enum EUserType {
    /** Email用户 */
    EMAIL(0),
    /** 账号卡用户 */
    ACCOUNT_CARD(1),
    /** 手机用户 */
    MOBILE(2),
    /** 邮箱绑定用户 */
    EMAIL_BINDING(3),
    /** 手机绑定用户 */
    MOBILE_BINDING(4),
    /** mac登录用户 */
    MAC(5),
    /** 三方用户 */
    THIRD_PARTY(6),
    ;

    final int code;

    EUserType(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static EUserType of(Integer code) {
        return Stream.of(values()).filter(userType -> Objects.equals(code, userType.code)).findAny().orElse(null);
    }
}
