package com.valor.vod.api.model.user;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Tom Tang
 * @date 2022/12/21
 */
public class UserTypeConverter {

    public static final Map<Integer, EAccountLoginType> USER_TYPE_CODE_TO_ACCOUNT_LOGIN_TYPE = new HashMap<Integer, EAccountLoginType>() {{
        put(EUserType.MAC.getCode(), EAccountLoginType.DEVICE);
        put(EUserType.ACCOUNT_CARD.getCode(), EAccountLoginType.ACCOUNT_CARD);
        put(EUserType.EMAIL.getCode(), EAccountLoginType.EMAIL);
        put(EUserType.MOBILE.getCode(), EAccountLoginType.MOBILE);
        put(EUserType.EMAIL_BINDING.getCode(), EAccountLoginType.AC_BINDING_EMAIL);
        put(EUserType.MOBILE_BINDING.getCode(), EAccountLoginType.AC_BINDING_MOBILE);
        put(EUserType.THIRD_PARTY.getCode(), EAccountLoginType.THIRD_PARTY);
    }};

    public static EAccountLoginType toAccountLoginType(Integer userTypeCode) {
        return USER_TYPE_CODE_TO_ACCOUNT_LOGIN_TYPE.get(userTypeCode);
    }

    public static EAccountLoginType toAccountLoginType(EUserType userType) {
        return USER_TYPE_CODE_TO_ACCOUNT_LOGIN_TYPE.get(userType.getCode());
    }
}
