/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.api.model.constant;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EPlaylistDisplayType {
    SUB_MENU("TYPE_LIST_V1"),
    TILED("TYPE_LIST_V3"),
    TOPIC("TYPE_LIST_TOPIC");

    private final String code;
    private static final Map<String, EPlaylistDisplayType> CODE_MAP;

    public static EPlaylistDisplayType of(String code) {
        if (code == null) {
            return null;
        }
        return CODE_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    private EPlaylistDisplayType(String code) {
        this.code = code;
    }

    static {
        CODE_MAP = Stream.of(EPlaylistDisplayType.values()).collect(Collectors.toMap(EPlaylistDisplayType::getCode, Function.identity()));
    }
}

