/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.api.model.constant;

public enum JobType {
    UNKNOWN,
    DIRECTOR,
    ACTOR,
    SOUNDTRACK,
    SELF,
    WRITER,
    PRODUCER,
    ACTRESS;


    public static JobType fromString(String type) {
        try {
            return JobType.valueOf(type.trim().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return UNKNOWN;
        }
    }

    public static JobType valueOf(int jobType) {
        switch (jobType) {
            case 1: {
                return DIRECTOR;
            }
            case 2: {
                return ACTOR;
            }
            case 3: {
                return SOUNDTRACK;
            }
            case 4: {
                return SELF;
            }
            case 5: {
                return WRITER;
            }
            case 6: {
                return PRODUCER;
            }
            case 7: {
                return ACTRESS;
            }
        }
        return UNKNOWN;
    }
}

