package com.valor.vod.api.model.constant;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 列表显示样式
 *
 * @author Tom Tang
 * @date 2021/11/22
 * @since 3.0.0
 */
@Getter
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public enum EPlaylistDisplayType {

    /**
     * 左侧菜单 + 右侧列表
     */
    SUB_MENU("TYPE_LIST_V1"),

    /**
     * 平铺
     */
    TILED("TYPE_LIST_V3"),

    /**
     * 专题
     */
    TOPIC("TYPE_LIST_TOPIC");

    private final String code;

    private static final Map<String, EPlaylistDisplayType> CODE_MAP = Stream.of(values())
        .collect(Collectors.toMap(EPlaylistDisplayType::getCode, Function.identity()));

    public static EPlaylistDisplayType of(String code) {
        if (code == null) {
            return null;
        }

        return CODE_MAP.get(code);
    }
}
